"""Initialize general models from local database.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import os

from dm.models.ModelsUtil import ModelsUtil
from dm.models.open_detector.generic_training_file_from_local_db import *
from dm.ConnectionUtil import ConnectionUtil as cu


if __name__ == '__main__':
    cu.setup_logging()

    table_name = 'measured_klarka'
    columns = ColumnMapper.OPEN_T_H
    no_event_shift = int(cu.open_detector('attrs.no_event.time_shift'))

    directory = cu.open_detector('generic.directory')
    if not os.path.isdir(directory):
        os.mkdir(directory)

    t_h_csv = cu.open_detector('generic.t_h.data_file.name') + '_from_local_db.bin'
    t_h_model = cu.open_detector('generic.t_h.model.name') + '_from_local_db.bin'
    data_t_h = training_set_t_h(cu.package('t_h.event_file.name'), no_event_shift, table_name,
                                t_h_csv, columns)
    ModelsUtil.write_model(data_t_h, t_h_model, ModelsUtil.replace_nothing_open)
