"""Initialize general models from a remote server.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import json
from dm.models.open_detector.generic_training_file import generic_training_file
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.WundergroundCom import WundergroundCom
from dm.models.open_detector.create_attrs import ColumnMapper
from dm.models.ModelsUtil import ModelsUtil


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    no_event_shift = int(cu.open_detector('attrs.no_event.time_shift'))

    with open(cu.open_detector('generic.devices.path'), 'r') as f:
        devs = json.load(f)

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    data_t_h = generic_training_file(cu.package('t_h.event_file.name'),
                                     no_event_shift, 't_h', ColumnMapper.OPEN_T_H, cls,
                                     devs, w)
    ModelsUtil.write_model(data_t_h, cu.open_detector('generic.t_h.model.name'),
                           ModelsUtil.replace_nothing_open)
