"""Initialize adapted model.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.open_detector.adapted_models import prepare_adapted_data_t_h
from dm.WundergroundCom import WundergroundCom
from dm.DateTimeUtil import DateTimeUtil


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    actual_time = int(DateTimeUtil.local_time_str_to_utc('2019/02/20 03:00:00').timestamp())
    lat = 49.1649894
    lon = 16.562262499999974

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    devs = [
        {
            'db_column_name': 'open_close',
            'gateway_id': '1908402624139667',
            'device_id': '0x900000000197053',
            'module_id': 0,
            'server_name': 'ant-work',
        },
        {
            'db_column_name': 'temperature_in2_celsius',
            'gateway_id': '1816820318180747',
            'device_id': '0xa900811026800001',
            'module_id': 0,
            'server_name': 'ant-work',
        },
        {
            'db_column_name': 'rh_in2_percentage',
            'gateway_id': '1816820318180747',
            'device_id': '0xa900811026800001',
            'module_id': 1,
            'server_name': 'ant-work',
        }
    ]

    prepare_adapted_data_t_h(devs, cls, actual_time - 24 * 60 * 60 * 15, actual_time,
                             lat, lon, w)
