"""Initialize general models from local database.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import os

from dm.models.ModelsUtil import ModelsUtil
from dm.models.open_detector.generic_training_file_from_local_db import *
from dm.ConnectionUtil import ConnectionUtil as cu


if __name__ == '__main__':
    cu.setup_logging()

    table_name = 'measured_filtered_peto'
    columns = ColumnMapper.OPEN_CO2
    no_event_shift = int(cu.open_detector('attrs.no_event.time_shift'))

    directory = cu.open_detector('generic.directory')
    if not os.path.isdir(directory):
        os.mkdir(directory)

    co2_csv = cu.open_detector('generic.co2.data_file.name') + '_from_local_db.bin'
    co2_model = cu.open_detector('generic.co2.model.name') + '_from_local_db.bin'
    data_co2 = training_set_co2(cu.package('co2.event_file.name'), no_event_shift, table_name,
                                co2_csv, columns)
    ModelsUtil.write_model(data_co2, co2_model, ModelsUtil.replace_nothing_open)
