"""Initialize general models from a remote server.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import json

from dm.models.open_detector.generic_training_file import generic_training_file
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.WundergroundCom import WundergroundCom
from dm.models.open_detector.create_attrs import ColumnMapper
from dm.models.ModelsUtil import ModelsUtil


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    no_event_shift = int(cu.open_detector('attrs.no_event.time_shift'))

    with open(cu.open_detector('generic.devices.path'), 'r') as f:
        devs = json.load(f)

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    data_co2 = generic_training_file(cu.package('co2.event_file.name'),
                                     no_event_shift, 'co2', ColumnMapper.OPEN_CO2, cls,
                                     devs, w)
    ModelsUtil.write_model(data_co2, cu.open_detector('generic.co2.model.name'),
                           ModelsUtil.replace_nothing_open)
