"""Initialize adapted model.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import time
import requests
import json

from dm.WundergroundCom import WundergroundCom
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.open_detector.adapted_models import prepare_adapted_data_co2


def prepare_adapted_co2(cls, actual_time):
    url_req = 'https://api.aurorahub.io/watchdogs-refresh'
    json_data = requests.get(url_req).text
    python_obj = json.loads(json_data)['co2_open_window']

    cl = cls['rehivetech']

    for item in python_obj:
        first_seen = None
        out_dev = []

        for dev in item['input']:
            res = cl.device_info(dev['gateway_id'], dev['device_id'])

            if first_seen is None:
                first_seen = res['first_seen']

            if first_seen is not None:
                first_seen = max(first_seen, res['first_seen'])

            if 'open_close' in dev['modules']:
                out_dev.append(
                    {
                        'db_column_name': 'open_close',
                        'name': 'BeeeOn sensor',
                        'gateway_id': str(dev['gateway_id']),
                        'device_id': str(dev['device_id']),
                        'module_id': dev['modules'].index('open_close'),
                        'server_name': 'rehivetech',
                    }
                )

            if 'co2' in dev['modules']:
                out_dev.append(
                    {
                        'db_column_name': 'co2_in_ppm',
                        'name': 'BeeeOn sensor',
                        'gateway_id': str(dev['gateway_id']),
                        'device_id': str(dev['device_id']),
                        'module_id': dev['modules'].index('co2'),
                        'server_name': 'rehivetech',
                    }
                )

        coord = item['location']['coord']
        prepare_adapted_data_co2(out_dev, cls, first_seen, actual_time,
                                 coord['lat'], coord['lon'], w)


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    actual_time = int(time.time())

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    prepare_adapted_co2(cls, actual_time)
