"""Detector.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.ModelsUtil import ModelsUtil
from dm.WundergroundCom import WundergroundCom
from dm.DateTimeUtil import DateTimeUtil


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    actual_time = int(DateTimeUtil.local_time_str_to_utc('2019/02/20 03:00:00').timestamp())
    lat = 49.1649894
    lon = 16.562262499999974

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    devs = [
        {
            'db_column_name': 'co2_in_ppm',
            'gateway_id': '1816820318180747',
            'device_id': '0xa900811026800001',
            'module_id': 2,
            'server_name': 'ant-work',
        }
    ]

    notification = ModelsUtil.estimate_open_co2(devs, cls, lat, lon, actual_time, w)
    ModelsUtil.json_to_file(notification, 'co2_notification.doc.json', log_notification=True)
