"""Creates statistics for ventilation length predictors.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from collections import OrderedDict
from dm.CSVUtil import CSVUtil
from dm.ConnectionUtil import ConnectionUtil as cu
from subprocess import PIPE, run
import logging

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


def list_of_processes(directory='ventilation_length'):
    return [
        '//DIP/{0}/RandomForest'.format(directory),
        '//DIP/{0}/NeuralNet'.format(directory),
    ]


if __name__ == '__main__':
    cu.setup_logging()

    logging.info('start')

    launcher = cu.rapid_miner()['launcher']

    out_s_maskou = []
    out_s_exp = []

    all = []
    for proc in list_of_processes():
        proc_name = proc.split('/')[-1]
        row_klasicky = [('nazov', proc_name), ('pristup', 'klasicky')]
        row_s_maskou = [('nazov', proc_name), ('pristup', 's_maskou')]
        row_s_exp = [('nazov', proc_name), ('pristup', 's_exp')]

        for bin in range(2, 33):
            cmd = [
                launcher,
                proc,
                '-Mnumber={0}'.format(bin),
            ]

            result = run(cmd, stdout=PIPE, stderr=PIPE, universal_newlines=True)

            output = str(run(['python3', 'performance_2.py'],  stdout=PIPE, universal_newlines=True).stdout).strip()
            p1 = output.split('\n')[1].split(' ')[2]
            p2 = output.split('\n')[bin + 4].split(' ')[2]
            row_klasicky.append(('bin_{0}'.format(bin), p1))
            row_s_maskou.append(('bin_{0}'.format(bin), p2))

            output = str(run(['python3', 'performance_1.py'], stdout=PIPE, universal_newlines=True).stdout).strip()
            p3 = str(output).strip()

            logging.info('{0}: {1}, {2}, {3}, {4}'.format(proc_name, bin, p1, p2, p3))
            row_s_exp.append(('bin_{0}'.format(bin), p3))

        out_s_maskou.append(OrderedDict(row_klasicky))
        out_s_maskou.append(OrderedDict(row_s_maskou))

        out_s_exp.append(OrderedDict(row_klasicky))
        out_s_exp.append(OrderedDict(row_s_exp))

        all.append(OrderedDict(row_klasicky))
        all.append(OrderedDict(row_s_maskou))
        all.append(OrderedDict(row_s_exp))

    CSVUtil.create_csv_file(out_s_maskou, 's_maskou.csv')
    CSVUtil.create_csv_file(out_s_exp, 's_exp.csv')
    CSVUtil.create_csv_file(all, 'all.csv')

