"""Detector for window opening based on CO2 decrease with iterations.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.models.open_detector.generic_training_file_from_local_db import *
from dm.ConnectionUtil import ConnectionUtil as cu
import os

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


if __name__ == '__main__':
    cu.setup_logging()

    # tabulka s CO2, ktora neprekroci hranicu 2000ppm
    table_name = 'measured_filtered_peto'
    columns = ColumnMapper.OPEN_CO2

    directory = 'co2'
    if not os.path.isdir(directory):
        os.mkdir(directory)

    training_set_co2(cu.package('co2.event_file.name'), -500, table_name,
                     '{0}/training.csv'.format(directory), columns)

    start = int(DateTimeUtil.local_time_str_to_utc('2018/10/07 06:00:00').timestamp())
    testing_set(table_name, start, start + 100,
                '{0}/testing.csv'.format(directory), columns)

    # testing_month(table_name, start, directory, columns)
    # generic_testing(directory, columns)
