"""Creates training and testing set for window opening detector.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.models.open_detector.generic_training_file_from_local_db import *
from dm.ConnectionUtil import ConnectionUtil as cu

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


if __name__ == '__main__':
    cu.setup_logging()

    table_name = 'measured_klarka'
    columns = ColumnMapper.OPEN_T_H

    training_set_t_h(cu.package('t_h.event_file.name'), -500, table_name,
                     'training.csv', columns)

    start = int(DateTimeUtil.local_time_str_to_utc('2018/11/26 06:00:00').timestamp())
    testing_set(table_name, start, start + 100,
                'testing.csv', columns)

    # testing_month(table_name, start, columns)
    # generic_testing(".", columns)
