"""Tests connection to database.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import json
import time
import logging
from dm.WundergroundCom import WundergroundCom
from dm.ConnectionUtil import ConnectionUtil as cu

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


if __name__ == '__main__':
    cu.setup_logging()

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    lat = 49.1649894
    lon = 16.562262499999974

    actual_time = int(time.time())
    res = w.weather_by_coordinates(['humidity_out', 'temperature_out'],
                                   actual_time-3600, actual_time, lat, lon)

    json.dumps(res, indent=4, sort_keys=True)
