"""Tests connection to database.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import json
import time
from dm.OpenWeatherOrg import OpenWeatherOrg
from dm.ConnectionUtil import ConnectionUtil as cu

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


if __name__ == '__main__':
    cu.setup_logging()

    w = OpenWeatherOrg()
    w.api_key = cu.open_weather_api_key()

    actual_time = int(time.time())
    res = w.weather_by_city_name(['humidity_out', 'temperature_out'],
                                 actual_time, actual_time + 3600, 'Brno')

    json.dumps(res, indent=4, sort_keys=True)
