import logging
import sys
import csv
import datetime as dt
from os.path import dirname, abspath, join
from matplotlib.dates import DateFormatter
import matplotlib.pyplot as plt

CODE_DIR = abspath(join(dirname(__file__), '../..', ''))
sys.path.append(CODE_DIR)

from dm.DateTimeUtil import DateTimeUtil
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.Storage import Storage
from dm.CSVUtil import CSVUtil


def simple_graph(filename):
    x1 = []
    raw_t = []
    y1 = []
    with open(filename) as f1:
        csv_reader = csv.DictReader(f1, delimiter=',')
        for row in csv_reader:
            try:
                y1.append(float(row['rh_in2_specific_g_kg']))
                x1.append(dt.datetime.fromtimestamp(float(row['measured_time'])))
                raw_t.append(float(row['measured_time']))
            except:
                continue

    # https://matplotlib.org/api/_as_gen/matplotlib.pyplot.plot.html
    fig, ax = plt.subplots(figsize=(7, 3))
    ax.plot(x1, y1, '-b', label='indoor specific humidity $SH_{in}$')

    # set time format
    formatter = DateFormatter('%M:%S')
    ax.xaxis.set_major_formatter(formatter)

    ax.grid()
    # fig.legend(loc=1)
    ax.set_xlabel('time [mm:ss]')
    ax.set_ylabel(r'$SH_{in}$ [g/kg]')

    # minimum
    ax.set_ylim(min(y1)-0.20, max(y1)+0.41)
    ax.set_xlim(dt.datetime.fromtimestamp(raw_t[0]), dt.datetime.fromtimestamp(raw_t[-1]))

    plt.xticks([
        dt.datetime.strptime('2018/12/20 16:35:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:35:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:35:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:35:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:40:00', '%Y/%m/%d %H:%M:%S'),
    ], rotation=50)


    xcoords = [
        dt.datetime.strptime('2018/12/20 16:35:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:35:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:35:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:35:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:36:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:37:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:38:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:00', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:15', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:30', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:39:45', '%Y/%m/%d %H:%M:%S'),
        dt.datetime.strptime('2018/12/20 16:40:00', '%Y/%m/%d %H:%M:%S'),
    ]

    colors = ['gray', 'gray', 'gray', 'gray', 'gray', 'gray', 'gray', 'red', 'gray', 'gray', 'gray', 'gray', 'gray',
              'gray', 'gray', 'gray', 'gray', 'gray', 'gray', 'gray', 'gray']

    for xc, c in zip(xcoords, colors):
        if c == 'red':
            ax.axvline(x=xc, c=c)
            continue
        ax.axvline(x=xc, c=c, lw=0.5)

    filename = simple_graph.__name__ + '.eps'
    fig.canvas.set_window_title(filename)

    plt.tight_layout()

    fig.savefig(filename, bbox_inches='tight', pad_inches=0)


if __name__ == '__main__':
    cu.setup_logging()

    con = cu.create_con()

    start = int(DateTimeUtil.local_time_str_to_utc('2018/12/20 16:35:00').timestamp())
    end = int(DateTimeUtil.local_time_str_to_utc('2018/12/20 16:40:00').timestamp())
    table_name = 'measured_klarka'

    all = Storage.dw_columns_ordered(con, start, end, 'measured_time,rh_in2_specific_g_kg', table_name)
    CSVUtil.create_csv_file(all, 'test.csv')

    simple_graph('test.csv')

    # plt.show()
