"""Abstract class for one value selector.

Selector can select value based on given time from a table.
"""
from abc import abstractmethod
from dm.selectors.AbstractSelector import AbstractSelector

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


class AbstractRowSelector(AbstractSelector):
    def __init__(self, con, table_name):
        self.con = con
        self.table_name = table_name
        super(AbstractRowSelector, self).__init__()

    @abstractmethod
    def row(self, column_name, time):
        """It selects one row from source.

        :param column_name: name of column that contains required values
        :param time: timestamp of required data
        :return: data from the column in given time
        """
        pass
