"""Simple interval selector from database.

Selector can select given intervals of values from a given table without cache.
"""
from dm.Storage import Storage
from dm.selectors.interval.AbstractTableIntervalSelector import AbstractTableIntervalSelector

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class SimpleTableIntervalSelector(AbstractTableIntervalSelector):
    def interval(self, column_name, start, end):
        """It select a required interval from database.

        :param column_name: name of column that contains required values
        :param start: timestamp that denotes start of the required interval
        :param end: timestamp that denotes end of the required interval
        :return: data from the column in given interval (start, end)
        """
        return Storage.select_interval(self.con, start, end, column_name, self.table_name)
