"""Abstract class for interval selector.

Selector can select given intervals of values from a given table.
"""
from abc import abstractmethod
from dm.selectors.AbstractSelector import AbstractSelector

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class AbstractTableIntervalSelector(AbstractSelector):
    def __init__(self, con, table_name):
        self.con = con
        self.table_name = table_name
        super(AbstractTableIntervalSelector, self).__init__()

    @abstractmethod
    def interval(self, column_name, start, end):
        """It selects a required interval from source.

        :param column_name: name of column that contains required values
        :param start: timestamp that denotes start of the required interval
        :param end: timestamp that denotes end of the required interval
        :return: data from the column in given interval (start, end)
        """
        pass
