"""Creates attributes used in models for window opening detector and predictor
   of optimal ventilation length.
"""
from dm.attrs.FirstDifferenceAttrA import FirstDifferenceAttrA
from dm.attrs.InOutDiff import InOutDiff
from dm.attrs.InLinear import InLinear
from dm.attrs.VentilationLength import VentilationLength
from dm.attrs.DiffInLinear import DiffInLinear
from dm.co2regression.SimpleExpRegression import SimpleExpRegression
from dm.attrs.CO2VentilationLength import CO2VentilationLength
from dm.attrs.Regression import Regression
from dm.attrs.DifferenceBetweenRealLinear import DifferenceBetweenRealLinear
from dm.attrs.FirstDifferenceAttrB import FirstDifferenceAttrB
from dm.attrs.SecondDifferenceAttr import SecondDifferenceAttr
from dm.attrs.GrowthRate import GrowthRate

__author__ = ''
__email__ = ''


class ColumnMapper:
    NO_EVENTS_RECORDS_CO2 = [
        # 01 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/08 00:07:30', 'nothing'),
        ('2018/10/08 00:55:30', 'nothing'),
        ('2018/10/08 23:20:30', 'nothing'),
        ('2018/10/09 10:21:30', 'nothing'),
        ('2018/10/09 11:10:00', 'nothing'),
        ('2018/10/09 14:13:00', 'nothing'),
        ('2018/10/09 22:51:00', 'nothing'),
        ('2018/10/09 22:55:30', 'nothing'),
        ('2018/10/11 13:48:30', 'nothing'),
        ('2018/10/11 19:07:30', 'nothing'),

        # 02 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/07 09:01:00', 'nothing'),
        ('2018/10/07 16:18:30', 'nothing'),
        ('2018/10/08 20:41:30', 'nothing'),
        ('2018/10/08 20:57:00', 'nothing'),
        ('2018/10/10 22:58:30', 'nothing'),
        ('2018/10/10 23:13:00', 'nothing'),
        ('2018/10/11 13:47:30', 'nothing'),
        ('2018/10/16 17:02:30', 'nothing'),
        ('2018/10/17 10:51:30', 'nothing'),
        ('2018/10/18 19:56:30', 'nothing'),

        # 03 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/07 08:58:00', 'nothing'),
        ('2018/10/07 11:36:00', 'nothing'),
        ('2018/10/08 19:20:00', 'nothing'),
        ('2018/10/09 22:28:00', 'nothing'),
        ('2018/10/11 18:51:30', 'nothing'),
        ('2018/10/13 13:25:30', 'nothing'),
        ('2018/10/13 18:31:30', 'nothing'),
        ('2018/10/14 00:40:00', 'nothing'),
        ('2018/10/14 09:08:30', 'nothing'),
        ('2018/10/14 18:41:30', 'nothing'),

        # 04 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/09 10:44:30', 'nothing'),
        ('2018/10/14 22:28:00', 'nothing'),
        ('2018/10/16 21:08:00', 'nothing'),
        ('2018/10/17 10:47:30', 'nothing'),
        ('2018/10/17 23:51:00', 'nothing'),
        ('2018/10/18 20:07:00', 'nothing'),
        ('2018/10/19 07:04:30', 'nothing'),
        ('2018/10/19 10:52:30', 'nothing'),
        ('2018/10/21 20:28:00', 'nothing'),
        ('2018/10/22 15:00:30', 'nothing'),

        # 05 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/09 10:45:30', 'nothing'),
        ('2018/10/15 00:26:00', 'nothing'),
        ('2018/10/19 07:06:00', 'nothing'),
        ('2018/10/22 12:33:00', 'nothing'),
        ('2018/10/22 16:39:30', 'nothing'),
        ('2018/10/28 08:04:00', 'nothing'),
        ('2018/10/28 15:39:30', 'nothing'),
        ('2018/10/31 00:15:00', 'nothing'),
        ('2018/10/31 23:35:00', 'nothing'),
        ('2018/11/02 20:30:00', 'nothing'),

        # 06 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/07 11:42:00', 'nothing'),
        ('2018/10/15 23:49:30', 'nothing'),
        ('2018/10/16 21:16:00', 'nothing'),
        ('2018/10/18 20:08:00', 'nothing'),
        ('2018/10/24 05:33:00', 'nothing'),
        ('2018/10/31 07:24:30', 'nothing'),
        ('2018/11/10 05:04:00', 'nothing'),
        ('2018/11/10 06:37:30', 'nothing'),
        ('2018/11/10 23:22:00', 'nothing'),
        ('2019/01/29 23:06:00', 'nothing'),

        # 07 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/17 12:36:30', 'nothing'),
        ('2018/10/19 10:52:30', 'nothing'),
        ('2018/11/10 03:05:30', 'nothing'),
        ('2018/11/10 06:38:00', 'nothing'),
        ('2018/11/20 18:23:00', 'nothing'),
        ('2018/11/24 07:35:00', 'nothing'),
        ('2018/12/01 04:33:00', 'nothing'),
        ('2019/01/08 03:18:30', 'nothing'),
        ('2019/01/08 14:42:30', 'nothing'),
        ('2019/01/09 15:47:30', 'nothing'),

        # 08 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/18 20:06:00', 'nothing'),
        ('2018/10/22 16:39:30', 'nothing'),
        ('2018/10/24 05:32:30', 'nothing'),
        ('2018/11/05 18:02:30', 'nothing'),
        ('2018/11/10 03:04:30', 'nothing'),
        ('2018/11/10 03:59:30', 'nothing'),
        ('2018/11/10 04:12:00', 'nothing'),
        ('2018/11/10 04:56:30', 'nothing'),
        ('2018/11/10 05:03:30', 'nothing'),
        ('2018/11/10 06:37:00', 'nothing'),

        # 09 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/14 00:01:30', 'nothing'),
        ('2018/10/14 14:59:00', 'nothing'),
        ('2018/10/21 20:27:30', 'nothing'),
        ('2018/10/23 18:24:30', 'nothing'),
        ('2018/10/31 07:16:30', 'nothing'),
        ('2018/11/08 12:23:30', 'nothing'),
        ('2018/11/09 23:29:30', 'nothing'),
        ('2018/11/10 03:08:30', 'nothing'),
        ('2018/11/10 23:25:00', 'nothing'),
        ('2018/11/16 11:54:00', 'nothing'),

        # 10 iteracia - SVM, 4 mesiace, 2;3
        ('2018/11/10 02:30:30', 'nothing'),
        ('2019/01/10 09:38:00', 'nothing'),
        ('2019/01/15 15:10:30', 'nothing'),
        ('2019/01/18 09:59:00', 'nothing'),
        ('2019/01/28 04:39:30', 'nothing'),
        ('2018/10/17 12:36:00', 'nothing'),
        ('2018/10/17 12:36:30', 'nothing'),
        ('2018/10/31 07:17:00', 'nothing'),
        ('2018/10/31 07:17:30', 'nothing'),
        ('2018/11/09 23:27:30', 'nothing'),

        # 11 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/14 18:47:00', 'nothing'),
        ('2018/10/17 12:36:00', 'nothing'),
        ('2018/11/09 23:28:30', 'nothing'),
        ('2018/11/11 01:07:00', 'nothing'),
        ('2018/11/11 01:07:30', 'nothing'),
        ('2018/11/11 01:08:00', 'nothing'),

        # 12 iteracia - SVM, 4 mesiace, 2;3
        ('2018/11/10 04:23:00', 'nothing'),
        ('2019/01/18 09:59:00', 'nothing'),
        ('2019/01/31 03:53:00', 'nothing'),

        # 13 iteracia - SVM, 4 mesiace, 2;3
        ('2018/10/31 07:16:30', 'nothing'),
        ('2018/11/10 23:14:00', 'nothing'),

        # 14 iteracia - SVM, 4 mesiace, 2;3
        ('2019/01/18 09:59:00', 'nothing'),

        # 15 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/10 20:59:30', 'nothing'),
        ('2018/10/14 22:55:30', 'nothing'),
        ('2018/10/15 13:53:30', 'nothing'),
        ('2018/10/16 21:33:30', 'nothing'),
        ('2018/10/17 15:18:30', 'nothing'),
        ('2018/10/19 13:51:00', 'nothing'),
        ('2018/10/20 16:40:30', 'nothing'),
        ('2018/10/20 19:09:30', 'nothing'),
        ('2018/10/21 02:55:30', 'nothing'),
        ('2018/10/21 04:44:30', 'nothing'),

        # 16 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/22 16:39:30', 'nothing'),
        ('2018/10/24 21:52:00', 'nothing'),
        ('2018/11/10 02:02:30', 'nothing'),
        ('2018/11/10 04:26:00', 'nothing'),
        ('2018/11/11 23:13:00', 'nothing'),
        ('2018/12/01 23:26:30', 'nothing'),
        ('2019/01/10 08:51:30', 'nothing'),
        ('2019/01/12 10:45:00', 'nothing'),
        ('2019/01/24 12:30:30', 'nothing'),
        ('2019/01/26 15:36:30', 'nothing'),

        # 17 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/24 03:21:30', 'nothing'),
        ('2018/10/24 03:22:00', 'nothing'),
        ('2018/12/02 21:14:00', 'nothing'),
        ('2018/12/06 17:45:00', 'nothing'),
        ('2019/01/15 15:11:00', 'nothing'),
        ('2019/01/28 04:27:30', 'nothing'),

        # 18 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/08 02:17:30', 'nothing'),
        ('2018/10/09 01:28:30', 'nothing'),
        ('2018/10/09 23:40:30', 'nothing'),
        ('2018/10/13 17:27:00', 'nothing'),
        ('2018/10/18 07:17:30', 'nothing'),
        ('2018/10/19 01:51:30', 'nothing'),
        ('2018/10/19 02:53:00', 'nothing'),
        ('2018/10/19 05:26:30', 'nothing'),
        ('2018/10/22 12:40:00', 'nothing'),
        ('2018/10/24 01:16:00', 'nothing'),

        # 19 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/24 04:25:00', 'nothing'),
        ('2018/10/24 04:57:30', 'nothing'),
        ('2018/10/24 06:55:30', 'nothing'),
        ('2018/10/27 13:23:00', 'nothing'),
        ('2018/11/01 19:35:00', 'nothing'),
        ('2018/11/03 12:29:00', 'nothing'),
        ('2018/11/10 00:46:30', 'nothing'),
        ('2018/11/10 05:01:00', 'nothing'),
        ('2018/11/14 02:25:00', 'nothing'),
        ('2018/11/23 13:49:30', 'nothing'),

        # 20 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/09 09:17:00', 'nothing'),
        ('2018/10/10 11:56:00', 'nothing'),
        ('2018/10/15 13:20:00', 'nothing'),
        ('2018/10/24 03:21:30', 'nothing'),
        ('2018/10/31 07:17:00', 'nothing'),
        ('2018/11/03 01:26:30', 'nothing'),
        ('2018/11/08 19:15:00', 'nothing'),
        ('2018/11/11 01:06:30', 'nothing'),
        ('2018/11/24 02:54:30', 'nothing'),
        ('2018/11/24 07:20:30', 'nothing'),

        # 21 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/07 09:00:30', 'nothing'),
        ('2018/10/07 11:36:30', 'nothing'),
        ('2018/10/11 18:47:30', 'nothing'),
        ('2018/10/11 20:56:30', 'nothing'),
        ('2018/10/11 21:00:00', 'nothing'),
        ('2018/10/13 11:11:00', 'nothing'),
        ('2018/10/13 13:32:00', 'nothing'),
        ('2018/10/14 10:54:30', 'nothing'),
        ('2018/10/14 15:01:30', 'nothing'),
        ('2018/10/14 18:45:30', 'nothing'),

        # 22 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/22 16:40:00', 'nothing'),
        ('2018/10/24 03:21:00', 'nothing'),
        ('2018/10/24 05:02:00', 'nothing'),
        ('2018/10/28 09:39:30', 'nothing'),
        ('2018/10/28 13:02:30', 'nothing'),
        ('2018/11/09 23:06:30', 'nothing'),
        ('2018/11/24 04:01:00', 'nothing'),
        ('2018/11/24 07:20:00', 'nothing'),
        ('2018/12/08 06:11:30', 'nothing'),
        ('2018/12/09 04:44:30', 'nothing'),

        # 23 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/07 11:35:30', 'nothing'),
        ('2018/10/15 13:14:30', 'nothing'),
        ('2018/10/19 06:52:00', 'nothing'),
        ('2018/10/31 07:16:00', 'nothing'),
        ('2018/11/09 22:01:30', 'nothing'),
        ('2018/11/09 23:14:30', 'nothing'),
        ('2018/11/10 02:28:30', 'nothing'),
        ('2018/11/10 03:04:00', 'nothing'),
        ('2018/11/13 14:39:00', 'nothing'),
        ('2018/11/24 04:02:30', 'nothing'),

        # 24 iteracia - Neural, 4 mesiace, 2;3
        ('2018/10/15 13:14:00', 'nothing'),
        ('2018/10/15 13:20:30', 'nothing'),
        ('2018/10/19 14:40:30', 'nothing'),
        ('2018/10/19 17:54:00', 'nothing'),
        ('2018/10/19 18:39:30', 'nothing'),
        ('2018/10/19 21:47:30', 'nothing'),
        ('2018/10/19 22:20:30', 'nothing'),
        ('2018/10/20 07:13:00', 'nothing'),
        ('2018/10/20 15:40:00', 'nothing'),
        ('2018/10/20 18:33:00', 'nothing'),

        # 25 iteracia - Tree, 4 mesiace, 2;3
        ('2019/01/10 09:39:00', 'nothing'),

        # 26 iteracia - RTree, 4 mesiace, 2;3
        ('2019/01/28 04:28:00', 'nothing'),
        ('2019/01/28 04:28:30', 'nothing'),

        # 27 iteracia - RTree, 4 mesiace, 2;3
        ('2018/10/31 07:14:30', 'nothing'),
        ('2018/11/10 01:47:00', 'nothing'),
        ('2018/11/11 04:34:00', 'nothing'),
        ('2018/11/24 07:32:00', 'nothing'),
        ('2018/11/28 03:33:30', 'nothing'),
        ('2018/12/01 04:31:00', 'nothing'),
        ('2018/12/01 17:57:30', 'nothing'),
        ('2018/12/02 00:06:00', 'nothing'),
        ('2018/12/16 05:55:00', 'nothing'),
        ('2019/01/14 07:12:30', 'nothing'),

        # 28 iteracia - RTree, 4 mesiace, 2;3
        ('2018/10/24 03:21:30', 'nothing'),
        ('2018/10/24 05:31:00', 'nothing'),
        ('2018/10/24 05:31:30', 'nothing'),
        ('2018/11/10 04:55:30', 'nothing'),
        ('2019/01/29 23:04:00', 'nothing'),
        ('2019/01/29 23:04:30', 'nothing'),

        # 29 iteracia - All, 4 mesiace, 2;3
        ('2018/10/08 00:07:30', 'nothing'),
        ('2018/10/08 00:55:30', 'nothing'),
        ('2018/10/08 19:09:30', 'nothing'),
        ('2018/10/09 10:21:30', 'nothing'),
        ('2018/10/09 10:52:30', 'nothing'),
        ('2018/10/09 11:10:00', 'nothing'),
        ('2018/10/09 14:13:00', 'nothing'),
        ('2018/10/11 13:48:30', 'nothing'),
        ('2018/10/11 19:07:30', 'nothing'),
        ('2018/10/13 01:58:00', 'nothing'),

        # 30 iteracia - All, 4 mesiace, 2;3
        ('2019/01/17 20:58:00', 'nothing'),
        ('2019/01/17 20:58:30', 'nothing'),
        ('2019/01/17 20:59:00', 'nothing'),
        ('2018/10/21 05:25:00', 'nothing'),
        ('2018/11/29 12:29:00', 'nothing'),
        ('2018/12/17 08:03:00', 'nothing'),
        ('2018/12/18 12:57:30', 'nothing'),
        ('2018/12/21 12:41:00', 'nothing'),
        ('2018/12/21 23:33:30', 'nothing'),
        ('2018/12/23 16:38:30', 'nothing'),

        # 31 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 15:32:30', 'nothing'),
        ('2018/10/07 16:35:30', 'nothing'),
        ('2018/10/07 20:57:30', 'nothing'),
        ('2018/10/13 07:34:30', 'nothing'),
        ('2018/10/11 19:06:30', 'nothing'),
        ('2018/10/16 00:29:30', 'nothing'),
        ('2018/10/16 21:31:00', 'nothing'),
        ('2018/10/16 23:55:00', 'nothing'),
        ('2018/10/31 17:06:30', 'nothing'),
        ('2018/10/31 23:10:00', 'nothing'),

        # 32 iteracia - All, 4 mesiace, 2;3
        ('2018/10/07 16:36:00', 'nothing'),
        ('2018/10/10 20:02:00', 'nothing'),
        ('2018/10/15 00:16:30', 'nothing'),
        ('2018/10/15 18:52:30', 'nothing'),
        ('2018/10/23 19:03:00', 'nothing'),
        ('2018/11/03 13:20:30', 'nothing'),
        ('2018/11/03 21:06:30', 'nothing'),
        ('2018/11/06 09:39:00', 'nothing'),
        ('2018/11/05 22:05:30', 'nothing'),
        ('2018/12/01 04:32:30', 'nothing'),

        # 33 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 17:26:30', 'nothing'),
        ('2018/10/09 11:21:00', 'nothing'),
        ('2018/10/11 14:30:00', 'nothing'),
        ('2018/10/15 09:02:00', 'nothing'),
        ('2018/10/20 19:11:00', 'nothing'),
        ('2018/10/29 19:56:00', 'nothing'),
        ('2018/11/02 15:23:00', 'nothing'),
        ('2018/11/06 21:46:00', 'nothing'),
        ('2018/11/10 06:11:30', 'nothing'),
        ('2018/11/22 18:12:00', 'nothing'),

        # 34 iteracia - , 4 mesiace, 2;3
        ('2018/10/07 20:56:30', 'nothing'),
        ('2018/10/09 23:02:00', 'nothing'),
        ('2018/10/13 12:38:30', 'nothing'),
        ('2018/10/17 21:47:30', 'nothing'),
        ('2018/10/21 19:29:30', 'nothing'),
        ('2018/11/04 08:34:00', 'nothing'),
        ('2018/11/18 23:55:00', 'nothing'),
        ('2018/11/28 07:30:00', 'nothing'),
        ('2018/12/24 05:55:00', 'nothing'),
        ('2019/01/02 02:07:00', 'nothing'),

        # 35 iteracia - All, 4 mesiace, 2;3
        ('2018/10/11 10:49:30', 'nothing'),
        ('2018/10/28 11:49:00', 'nothing'),
        ('2018/10/31 07:30:30', 'nothing'),
        ('2018/11/04 08:22:30', 'nothing'),
        ('2018/11/10 01:23:00', 'nothing'),
        ('2018/11/13 20:14:00', 'nothing'),
        ('2018/11/18 20:23:00', 'nothing'),
        ('2018/11/20 19:59:30', 'nothing'),
        ('2018/12/02 04:30:30', 'nothing'),
        ('2019/01/08 00:10:30', 'nothing'),

        # 36 iteracia - All, 4 mesiace, 2;3
        ('2018/10/11 12:44:30', 'nothing'),
        ('2018/10/17 16:59:30', 'nothing'),
        ('2018/10/29 23:47:30', 'nothing'),
        ('2018/11/06 23:35:00', 'nothing'),
        ('2018/11/11 00:07:00', 'nothing'),
        ('2018/11/24 16:58:00', 'nothing'),
        ('2018/12/08 11:25:00', 'nothing'),
        ('2019/01/10 11:03:30', 'nothing'),
        ('2019/01/26 00:02:30', 'nothing'),
        ('2019/01/27 12:50:30', 'nothing'),

        # 37 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 10:52:00', 'nothing'),
        ('2018/10/17 19:22:00', 'nothing'),
        ('2018/11/07 16:49:30', 'nothing'),
        ('2018/11/10 00:58:00', 'nothing'),
        ('2018/11/10 04:09:30', 'nothing'),
        ('2018/11/13 14:54:00', 'nothing'),
        ('2018/12/05 17:57:00', 'nothing'),
        ('2019/01/09 16:01:00', 'nothing'),
        ('2019/01/29 23:15:30', 'nothing'),
        ('2018/10/28 13:32:30', 'nothing'),

        # 38 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 16:49:30', 'nothing'),
        ('2018/10/13 14:14:30', 'nothing'),
        ('2018/10/16 14:55:00', 'nothing'),
        ('2018/10/24 06:09:30', 'nothing'),
        ('2018/10/29 23:49:30', 'nothing'),
        ('2018/11/03 01:26:00', 'nothing'),
        ('2018/11/20 20:03:30', 'nothing'),
        ('2018/11/29 17:40:00', 'nothing'),
        ('2018/12/12 08:36:30', 'nothing'),
        ('2019/01/28 04:38:00', 'nothing'),

        # 39 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 17:26:00', 'nothing'),
        ('2018/10/15 11:49:30', 'nothing'),
        ('2018/10/28 08:10:30', 'nothing'),
        ('2018/11/07 04:38:00', 'nothing'),
        ('2018/11/10 00:47:30', 'nothing'),
        ('2018/11/10 04:09:00', 'nothing'),
        ('2018/11/13 11:19:30', 'nothing'),
        ('2018/11/24 00:40:30', 'nothing'),
        ('2018/12/06 13:17:30', 'nothing'),
        ('2019/01/26 00:01:30', 'nothing'),

        # 40 iteracia - All, 4 mesiace, 2;3
        ('2018/10/07 13:54:30', 'nothing'),
        ('2018/10/11 14:55:30', 'nothing'),
        ('2018/10/15 18:35:00', 'nothing'),
        ('2018/10/18 20:11:00', 'nothing'),
        ('2018/10/22 11:48:30', 'nothing'),
        ('2018/11/07 09:52:00', 'nothing'),
        ('2018/11/13 17:03:30', 'nothing'),
        ('2018/12/03 22:20:30', 'nothing'),
        ('2018/12/22 19:01:30', 'nothing'),
        ('2019/01/17 18:17:30', 'nothing'),

        # 41 iteracia - All, 4 mesiace, 2;3
        ('2018/10/07 18:34:30', 'nothing'),
        ('2018/10/18 01:44:00', 'nothing'),
        ('2018/10/23 01:04:00', 'nothing'),
        ('2018/10/26 10:46:00', 'nothing'),
        ('2018/10/27 01:15:30', 'nothing'),
        ('2018/10/28 07:24:00', 'nothing'),
        ('2018/11/01 19:34:30', 'nothing'),
        ('2018/11/10 02:14:00', 'nothing'),
        ('2018/11/13 15:01:30', 'nothing'),
        ('2018/11/23 11:51:30', 'nothing'),

        # 42 iteracia - All, 4 mesiace, 2;3
        ('2018/10/07 12:00:00', 'nothing'),
        ('2018/10/11 17:26:00', 'nothing'),
        ('2018/10/21 10:01:30', 'nothing'),
        ('2018/10/31 22:51:30', 'nothing'),
        ('2018/11/20 20:01:00', 'nothing'),
        ('2018/12/07 10:28:30', 'nothing'),
        ('2019/01/11 15:20:00', 'nothing'),
        ('2019/01/29 22:49:30', 'nothing'),
        ('2019/01/29 06:41:30', 'nothing'),
        ('2018/11/13 20:14:30', 'nothing'),

        # 43 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 13:30:30', 'nothing'),
        ('2018/10/15 08:57:00', 'nothing'),
        ('2018/10/21 03:22:00', 'nothing'),
        ('2018/10/30 18:22:00', 'nothing'),
        ('2018/11/13 20:03:30', 'nothing'),
        ('2018/12/06 17:45:30', 'nothing'),
        ('2018/12/25 02:11:30', 'nothing'),
        ('2019/01/31 19:22:00', 'nothing'),
        ('2019/01/22 17:08:30', 'nothing'),
        ('2018/11/20 20:29:00', 'nothing'),

        # 44 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 10:20:30', 'nothing'),
        ('2018/10/17 23:51:30', 'nothing'),
        ('2018/10/27 13:23:30', 'nothing'),
        ('2018/11/03 19:53:00', 'nothing'),
        ('2018/11/07 16:32:00', 'nothing'),
        ('2018/11/11 11:37:30', 'nothing'),
        ('2018/11/24 18:27:30', 'nothing'),
        ('2018/12/01 21:11:00', 'nothing'),
        ('2018/12/09 02:11:30', 'nothing'),
        ('2019/01/30 05:33:30', 'nothing'),

        # 45 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 10:21:00', 'nothing'),
        ('2018/10/17 16:31:00', 'nothing'),
        ('2018/10/28 15:38:30', 'nothing'),
        ('2018/11/09 22:46:00', 'nothing'),
        ('2018/11/10 01:56:00', 'nothing'),
        ('2018/11/10 04:57:00', 'nothing'),
        ('2018/11/18 13:47:00', 'nothing'),
        ('2019/01/15 15:10:00', 'nothing'),
        ('2019/01/18 10:14:30', 'nothing'),
        ('2019/01/30 13:27:00', 'nothing'),

        # 46 iteracia - All, 4 mesiace, 2;3
        ('2018/10/14 22:56:00', 'nothing'),
        ('2018/10/15 13:22:00', 'nothing'),
        ('2018/10/16 07:16:00', 'nothing'),
        ('2018/10/16 21:34:00', 'nothing'),
        ('2018/10/18 07:11:30', 'nothing'),
        ('2018/10/29 12:45:00', 'nothing'),
        ('2019/01/30 05:34:00', 'nothing'),
        ('2019/01/10 08:49:00', 'nothing'),
        ('2018/11/10 05:25:00', 'nothing'),
        ('2018/11/10 04:02:30', 'nothing'),

        # 47 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 17:25:30', 'nothing'),
        ('2018/10/17 14:33:30', 'nothing'),
        ('2018/10/18 17:40:00', 'nothing'),
        ('2018/11/03 17:26:30', 'nothing'),
        ('2018/11/10 00:47:00', 'nothing'),
        ('2018/11/10 03:06:00', 'nothing'),
        ('2018/11/20 10:36:00', 'nothing'),
        ('2018/11/26 11:51:30', 'nothing'),
        ('2018/12/24 20:36:30', 'nothing'),
        ('2019/01/15 00:03:00', 'nothing'),

        # 48 iteracia - All, 4 mesiace, 2;3
        ('2018/10/11 14:29:00', 'nothing'),
        ('2018/11/02 18:33:30', 'nothing'),
        ('2018/10/09 18:57:30', 'nothing'),
        ('2018/11/09 22:23:00', 'nothing'),
        ('2018/11/09 23:26:00', 'nothing'),
        ('2018/11/10 00:30:00', 'nothing'),
        ('2018/12/29 02:13:00', 'nothing'),
        ('2019/01/08 14:41:30', 'nothing'),
        ('2019/01/09 16:45:00', 'nothing'),
        ('2019/01/26 15:17:00', 'nothing'),

        # 49 iteracia - All, 4 mesiace, 2;3
        ('2018/10/14 00:39:00', 'nothing'),
        ('2018/10/16 07:14:30', 'nothing'),
        ('2018/10/31 22:41:00', 'nothing'),
        ('2018/11/10 01:27:00', 'nothing'),
        ('2018/11/11 22:47:00', 'nothing'),
        ('2018/12/01 20:48:00', 'nothing'),
        ('2018/12/15 22:13:30', 'nothing'),
        ('2018/12/19 10:45:30', 'nothing'),
        ('2018/12/23 18:05:00', 'nothing'),
        ('2019/01/24 17:35:30', 'nothing'),

        # 50 iteracia - All, 4 mesiace, 2;3
        ('2018/11/09 23:28:00', 'nothing'),
        ('2018/11/30 23:05:00', 'nothing'),
        ('2018/12/07 23:17:30', 'nothing'),

        # 51 iteracia - All, 4 mesiace, 2;3
        ('2018/10/11 14:28:00', 'nothing'),
        ('2018/10/17 19:18:30', 'nothing'),
        ('2018/10/27 16:49:00', 'nothing'),
        ('2018/11/03 16:49:30', 'nothing'),
        ('2018/11/04 10:04:30', 'nothing'),
        ('2018/11/04 19:37:00', 'nothing'),
        ('2018/11/07 07:23:00', 'nothing'),
        ('2018/11/12 11:58:00', 'nothing'),
        ('2018/12/08 11:11:00', 'nothing'),
        ('2018/12/26 01:29:00', 'nothing'),

        # 52 iteracia - All, 4 mesiace, 2;3
        ('2018/10/15 01:23:30', 'nothing'),
        ('2018/11/09 22:50:00', 'nothing'),
        ('2018/11/09 23:51:30', 'nothing'),
        ('2019/01/17 20:57:30', 'nothing'),

        # 53 iteracia - All, 4 mesiace, 2;3
        ('2018/10/17 11:32:00', 'nothing'),
        ('2018/10/28 08:17:00', 'nothing'),
        ('2018/10/29 12:45:30', 'nothing'),
        ('2018/10/29 12:45:30', 'nothing'),
        ('2018/11/03 01:27:00', 'nothing'),
        ('2018/11/09 23:01:30', 'nothing'),
        ('2018/11/10 01:23:30', 'nothing'),
        ('2018/11/10 02:03:00', 'nothing'),
        ('2018/11/22 17:51:30', 'nothing'),
        ('2018/11/23 11:56:00', 'nothing'),

        # 54 iteracia - All, 4 mesiace, 2;3
        ('2018/11/10 02:51:00', 'nothing'),

        # 55 iteracia - All, 4 mesiace, 2;3
        ('2018/11/10 00:18:30', 'nothing'),

        # 56 iteracia - All, 4 mesiace, 2;3
        ('2018/10/09 10:10:00', 'nothing'),
        ('2018/11/01 07:08:00', 'nothing'),
        ('2018/11/10 02:51:30', 'nothing'),
        ('2019/01/23 13:42:00', 'nothing'),

        # 57 iteracia - All, 4 mesiace, 2;3
        ('2018/11/10 02:29:00', 'nothing'),
        ('2018/11/10 04:31:30', 'nothing'),
        ('2019/01/09 15:46:30', 'nothing'),

        # 58 iteracia - All, 4 mesiace, 2;3
        ('2018/11/09 23:27:30', 'nothing'),
    ]

    NO_EVENTS_RECORDS_T_H = [
        # 1. iteration
        ('2018/11/27 08:10:30', 'nothing'),
        ('2018/11/29 02:08:00', 'nothing'),
        ('2018/11/30 23:02:00', 'nothing'),
        ('2018/12/01 12:52:00', 'nothing'),
        ('2018/12/01 16:00:30', 'nothing'),
        ('2018/12/02 01:15:30', 'nothing'),
        ('2018/12/03 10:08:30', 'nothing'),
        ('2018/12/03 15:08:30', 'nothing'),
        ('2018/12/06 18:26:00', 'nothing'),
        ('2018/12/06 23:31:30', 'nothing'),

        # 2. iteration
        ('2018/12/01 15:48:00', 'nothing'),
        ('2018/12/02 10:28:00', 'nothing'),
        ('2018/12/03 10:08:00', 'nothing'),
        ('2018/12/03 23:00:30', 'nothing'),
        ('2018/12/04 12:16:30', 'nothing'),
        ('2018/12/05 08:19:00', 'nothing'),
        ('2018/12/07 11:55:30', 'nothing'),
        ('2018/12/07 22:44:00', 'nothing'),
        ('2018/12/19 12:26:00', 'nothing'),
        ('2018/12/19 17:28:30', 'nothing'),

        # 3. iteration
        ('2018/12/03 18:51:00', 'nothing'),
        ('2018/12/16 07:55:30', 'nothing'),
        ('2018/12/22 08:17:00', 'nothing'),
        ('2018/12/24 07:27:00', 'nothing'),
        ('2018/12/24 08:11:00', 'nothing'),
        ('2018/12/26 12:45:30', 'nothing'),
        ('2018/12/27 12:49:30', 'nothing'),
        ('2018/12/27 15:39:30', 'nothing'),
        ('2018/12/28 11:54:00', 'nothing'),
        ('2018/12/28 15:40:00', 'nothing'),

        # 4. iteration
        ('2018/12/26 18:32:00', 'nothing'),
        ('2018/12/27 20:19:30', 'nothing'),
        ('2018/12/28 06:19:30', 'nothing'),
        ('2018/12/30 07:27:00', 'nothing'),
        ('2018/12/30 10:06:00', 'nothing'),
        ('2018/12/31 06:38:00', 'nothing'),
        ('2018/12/31 11:53:30', 'nothing'),
        ('2019/01/01 17:04:00', 'nothing'),
        ('2019/01/08 06:42:00', 'nothing'),
        ('2019/01/08 21:53:30', 'nothing'),

        # 5. iteration
        ('2018/12/27 23:48:00', 'nothing'),
        ('2018/12/28 09:42:30', 'nothing'),
        ('2018/12/28 22:01:00', 'nothing'),
        ('2018/12/31 06:27:30', 'nothing'),
        ('2018/12/31 11:53:30', 'nothing'),
        ('2019/01/02 10:04:30', 'nothing'),
        ('2019/01/03 06:18:30', 'nothing'),
        ('2019/01/04 21:53:00', 'nothing'),
        ('2019/01/07 06:21:30', 'nothing'),
        ('2019/01/08 10:18:30', 'nothing'),

        # 6. iteration
        ('2018/12/26 06:18:30', 'nothing'),
        ('2019/01/08 21:59:00', 'nothing'),
        ('2019/01/13 09:07:30', 'nothing'),
        ('2019/01/19 22:32:00', 'nothing'),
        ('2019/02/01 18:21:30', 'nothing'),
        ('2019/02/11 16:58:00', 'nothing'),
        ('2019/02/15 20:06:30', 'nothing'),
        ('2019/02/19 18:06:30', 'nothing'),
        ('2019/02/27 18:58:30', 'nothing'),
        ('2019/03/02 19:42:30', 'nothing'),

        # 7. iteration
        ('2019/03/03 15:01:30', 'nothing'),
        ('2019/03/08 12:21:00', 'nothing'),
        ('2019/03/09 07:55:30', 'nothing'),
        ('2019/03/10 19:12:00', 'nothing'),
        ('2019/03/10 19:48:00', 'nothing'),
        ('2019/03/14 06:23:30', 'nothing'),
        ('2019/03/14 07:28:00', 'nothing'),
        ('2019/03/15 12:50:30', 'nothing'),
        ('2019/03/20 10:40:00', 'nothing'),
        ('2019/03/21 08:02:30', 'nothing'),

        # 8. iteration
        ('2019/02/27 18:58:30', 'nothing'),
        ('2019/03/09 07:55:30', 'nothing'),
        ('2019/03/14 07:28:00', 'nothing'),
        ('2019/03/24 10:23:00', 'nothing'),
        ('2018/11/26 22:27:00', 'nothing'),
        ('2018/12/06 20:56:00', 'nothing'),
        ('2018/12/16 07:55:30', 'nothing'),
        ('2018/12/26 06:18:30', 'nothing'),
        ('2018/12/26 18:31:30', 'nothing'),
        ('2019/01/15 06:58:00', 'nothing'),

        # 9. iteration
        ('2019/01/05 16:09:00', 'nothing'),
        ('2019/01/05 16:57:30', 'nothing'),
        ('2019/01/08 21:58:30', 'nothing'),
        ('2019/01/19 12:14:00', 'nothing'),
        ('2019/01/19 21:12:00', 'nothing'),
        ('2019/02/08 06:31:30', 'nothing'),
        ('2019/03/05 06:23:30', 'nothing'),
        ('2019/03/09 07:55:30', 'nothing'),
        ('2019/03/15 08:08:30', 'nothing'),
        ('2019/03/20 10:40:00', 'nothing'),

        # 10. iteration
        ('2019/01/16 07:48:00', 'nothing'),
        ('2019/01/19 12:14:00', 'nothing'),
        ('2019/01/21 21:45:00', 'nothing'),
        ('2019/02/11 11:13:30', 'nothing'),
        ('2019/01/30 19:27:30', 'nothing'),  # dvojzakmit
        ('2019/01/30 19:28:00', 'nothing'),
        ('2019/02/20 18:47:30', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),
        ('2019/02/24 11:03:30', 'nothing'),
        ('2019/02/24 11:05:00', 'nothing'),

        # 11. iteration
        ('2018/12/03 07:14:00', 'nothing'),
        ('2018/12/03 07:14:30', 'nothing'),
        ('2018/12/26 18:32:30', 'nothing'),
        ('2019/01/05 16:58:00', 'nothing'),
        ('2019/01/21 21:46:00', 'nothing'),
        ('2019/01/21 21:50:00', 'nothing'),
        ('2019/01/30 19:28:00', 'nothing'),
        ('2019/02/20 18:47:30', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),
        ('2019/02/27 18:58:30', 'nothing'),

        # 12. iteration
        ('2018/12/03 07:14:00', 'nothing'),
        ('2018/12/03 07:14:30', 'nothing'),
        ('2018/12/20 10:42:00', 'nothing'),
        ('2018/12/20 10:42:30', 'nothing'),
        ('2019/01/27 11:15:30', 'nothing'),
        ('2019/01/27 11:16:00', 'nothing'),
        ('2019/01/30 19:28:00', 'nothing'),
        ('2019/02/11 11:11:30', 'nothing'),
        ('2019/02/20 18:47:30', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),

        # 13. iteration
        ('2018/12/03 07:14:00', 'nothing'),
        ('2018/12/03 07:14:30', 'nothing'),
        ('2019/01/16 11:29:00', 'nothing'),
        ('2019/01/16 11:29:30', 'nothing'),
        ('2019/01/30 19:28:00', 'nothing'),
        ('2019/02/11 09:39:00', 'nothing'),
        ('2019/02/11 09:40:30', 'nothing'),
        ('2019/02/11 16:52:00', 'nothing'),
        ('2019/02/13 22:14:00', 'nothing'),
        ('2019/02/13 22:14:30', 'nothing'),

        # 14. iteration
        ('2018/12/07 15:35:00', 'nothing'),
        ('2018/12/20 10:42:00', 'nothing'),
        ('2018/12/20 10:42:30', 'nothing'),
        ('2019/01/15 09:15:00', 'nothing'),
        ('2019/02/04 18:51:00', 'nothing'),
        ('2019/02/04 18:51:30', 'nothing'),
        ('2019/02/11 09:39:00', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),
        ('2019/02/24 11:05:00', 'nothing'),
        ('2019/02/27 18:58:30', 'nothing'),

        # 15. iteration
        ('2018/12/20 10:42:00', 'nothing'),
        ('2018/12/20 10:42:30', 'nothing'),
        ('2019/02/04 18:51:00', 'nothing'),
        ('2019/02/04 18:51:30', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),
        ('2019/02/24 11:05:00', 'nothing'),
        ('2019/03/14 18:09:30', 'nothing'),
        ('2019/03/16 12:21:30', 'nothing'),
        ('2019/03/16 12:22:00', 'nothing'),
        ('2019/03/25 09:15:30', 'nothing'),

        # 16. iteration
        ('2018/12/20 10:42:00', 'nothing'),
        ('2018/12/20 10:42:30', 'nothing'),
        ('2019/01/16 11:28:00', 'nothing'),
        ('2019/01/16 11:30:00', 'nothing'),
        ('2019/01/21 21:52:00', 'nothing'),
        ('2019/02/04 18:51:00', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),
        ('2019/01/28 22:03:30', 'nothing'),  # trojzakmity
        ('2019/01/28 22:04:00', 'nothing'),
        ('2019/01/28 22:04:30', 'nothing'),

        # 17. iteration
        ('2018/12/20 07:03:00', 'nothing'),
        ('2018/12/20 10:42:00', 'nothing'),
        ('2019/01/15 09:16:00', 'nothing'),
        ('2019/01/16 11:28:30', 'nothing'),
        ('2019/01/21 21:45:00', 'nothing'),
        ('2019/01/21 21:50:30', 'nothing'),
        ('2019/01/25 06:50:30', 'nothing'),
        ('2019/01/27 11:15:30', 'nothing'),
        ('2019/02/03 08:20:30', 'nothing'),
        ('2019/02/11 09:39:30', 'nothing'),

        # 18. iteration
        ('2018/12/20 10:42:00', 'nothing'),
        ('2019/01/30 06:17:30', 'nothing'),
        ('2019/02/07 20:46:00', 'nothing'),
        ('2019/02/07 20:47:30', 'nothing'),
        ('2019/02/13 22:09:00', 'nothing'),
        ('2019/02/13 22:12:30', 'nothing'),
        ('2019/02/14 07:15:30', 'nothing'),
        ('2019/02/14 07:16:00', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),
        ('2019/03/16 12:22:00', 'nothing'),

        # 19. iteration
        ('2019/01/16 11:30:30', 'nothing'),
        ('2019/02/14 07:15:30', 'nothing'),
        ('2019/02/14 07:16:00', 'nothing'),
        ('2019/03/09 16:24:30', 'nothing'),
        ('2019/03/25 19:22:30', 'nothing'),
        ('2019/03/25 19:23:00', 'nothing'),
        ('2019/01/13 18:50:00', 'nothing'),  # ctyrzakmit
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/13 18:51:30', 'nothing'),

        # 20. iteration
        ('2019/01/13 18:50:00', 'nothing'),
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/13 18:51:30', 'nothing'),
        ('2019/01/16 11:28:00', 'nothing'),
        ('2019/01/16 11:37:00', 'nothing'),
        ('2019/01/23 07:11:00', 'nothing'),
        ('2019/01/23 07:11:30', 'nothing'),
        ('2019/01/23 07:12:00', 'nothing'),
        ('2019/03/16 15:26:00', 'nothing'),

        # 21. iteration
        ('2019/01/13 18:50:00', 'nothing'),
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/15 09:15:00', 'nothing'),
        ('2019/01/26 12:10:00', 'nothing'),
        ('2019/01/26 12:10:30', 'nothing'),
        ('2019/02/04 09:42:00', 'nothing'),
        ('2019/02/04 09:42:30', 'nothing'),
        ('2019/02/04 09:43:00', 'nothing'),
        ('2019/02/14 07:15:30', 'nothing'),

        # 22. iteration
        ('2019/01/13 18:50:00', 'nothing'),
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/26 12:10:00', 'nothing'),
        ('2019/02/04 09:42:30', 'nothing'),
        ('2019/02/04 09:43:00', 'nothing'),
        ('2019/02/10 10:34:00', 'nothing'),
        ('2019/02/10 10:34:30', 'nothing'),
        ('2019/02/13 22:14:30', 'nothing'),
        ('2019/02/20 18:48:00', 'nothing'),

        # 23. iteration
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/02/04 09:43:00', 'nothing'),
        ('2019/02/10 10:34:00', 'nothing'),
        ('2019/02/10 10:34:30', 'nothing'),
        ('2019/02/21 18:02:00', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/21 18:03:00', 'nothing'),
        ('2019/03/25 19:22:30', 'nothing'),
        ('2019/03/25 19:23:00', 'nothing'),

        # 24. iteration
        ('2018/12/22 08:17:30', 'nothing'),
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/02/04 09:43:00', 'nothing'),
        ('2019/02/10 10:34:00', 'nothing'),
        ('2019/02/21 18:02:00', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/03/09 16:24:00', 'nothing'),
        ('2019/03/25 19:22:30', 'nothing'),
        ('2019/03/25 19:23:00', 'nothing'),

        # 25. iteration
        ('2019/01/13 18:50:30', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/20 21:25:00', 'nothing'),
        ('2019/01/20 21:25:30', 'nothing'),
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/01/20 21:26:30', 'nothing'),
        ('2019/02/10 10:34:00', 'nothing'),
        ('2019/02/13 22:10:00', 'nothing'),
        ('2019/02/21 18:02:00', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),

        # 26. iteration
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/20 21:25:00', 'nothing'),
        ('2019/01/20 21:25:30', 'nothing'),
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/01/20 21:26:30', 'nothing'),
        ('2019/01/26 12:09:30', 'nothing'),
        ('2019/01/26 12:10:30', 'nothing'),
        ('2019/01/26 12:11:30', 'nothing'),
        ('2019/01/30 06:17:30', 'nothing'),
        ('2019/02/10 10:34:00', 'nothing'),

        # 27. iteration
        ('2018/12/07 15:35:00', 'nothing'),
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/20 21:25:00', 'nothing'),
        ('2019/01/20 21:25:30', 'nothing'),
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/02/13 22:09:00', 'nothing'),
        ('2019/02/13 22:10:00', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/25 20:41:30', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),

        # 28. iteration
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/16 11:37:00', 'nothing'),
        ('2019/01/21 21:45:30', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/02/26 13:01:00', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),
        ('2019/03/08 17:27:30', 'nothing'),

        # 29. iteration
        ('2019/01/13 18:51:00', 'nothing'),
        ('2019/01/20 21:25:00', 'nothing'),
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/02/26 13:01:00', 'nothing'),
        ('2019/02/27 16:04:30', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),

        # 30. iteration
        ('2018/12/24 15:22:30', 'nothing'),
        ('2019/01/19 21:13:00', 'nothing'),
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/02 12:16:00', 'nothing'),
        ('2019/03/02 12:17:00', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),

        # 31. iteration
        ('2019/01/28 22:02:00', 'nothing'),
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/02 12:16:00', 'nothing'),
        ('2019/03/02 12:17:00', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),
        ('2019/03/05 08:32:00', 'nothing'),
        ('2019/03/25 22:22:30', 'nothing'),

        # 32. iteration
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/02 12:17:00', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),
        ('2019/03/07 21:01:00', 'nothing'),

        # 33. iteration
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/02 12:17:00', 'nothing'),
        ('2019/03/02 12:56:30', 'nothing'),

        # 34. iteration
        ('2018/12/03 16:00:00', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/25 19:22:30', 'nothing'),

        # 35. iteration
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/01/20 21:26:30', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/21 08:02:00', 'nothing'),

        # 36. iteration
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/05 08:32:00', 'nothing'),
        ('2019/03/21 08:02:30', 'nothing'),

        # 37. iteration
        ('2019/01/20 21:26:00', 'nothing'),
        ('2019/01/20 21:26:30', 'nothing'),
        ('2019/02/10 21:28:30', 'nothing'),
        ('2019/02/26 13:00:30', 'nothing'),
        ('2019/03/21 08:02:00', 'nothing'),

        # 38. iteration
        ('2018/12/26 04:36:00', 'nothing'),
        ('2019/02/03 08:20:30', 'nothing'),
        ('2019/02/21 18:02:30', 'nothing'),
        ('2019/02/26 12:59:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),
        ('2019/03/02 12:17:00', 'nothing'),

        # 39. iteration
        ('2019/01/21 21:45:30', 'nothing'),

        # 40. iteration
        ('2019/01/16 11:29:30', 'nothing'),
        ('2019/02/26 13:00:00', 'nothing'),

        # 41. iteration
        ('2018/12/03 16:00:00', 'nothing'),
    ]

    OPEN_CO2 = \
        {
            'co2_in_ppm': 'co2_in',
        }

    OPEN_T_H = \
        {
            'rh_in2_specific_g_kg': 'rh_in_specific',
            'rh_in2_absolute_g_m3': 'rh_in_absolute',
            'temperature_in2_celsius': 'temperature_in',
        }

    PREDICTOR_T_H = \
        {
            'rh_in2_specific_g_kg_diff': 'rh_in_specific_diff',
            'rh_in2_absolute_g_m3_diff': 'rh_in_absolute_diff',
            'temperature_in2_celsius_diff': 'temperature_diff',
        }

    PREDICTOR_CO2 = \
        {
            'rh_in_specific_g_kg_diff': 'rh_in_specific_diff',
            'rh_in_absolute_g_m3_diff': 'rh_in_absolute_diff',
            'temperature_in_celsius_diff': 'temperature_in_diff',
            'co2_in_ppm_diff': 'co2_in_diff',
        }


def func_co2(timestamp, row_selector, interval_selector, columns_map, end=None):
    """It calculates attributes used for detector creation on the basis of CO2 concentration that
       detects window opening.

    :param timestamp: timestamp when an event occurred
    :param row_selector: selector of row
    :param interval_selector: selector of interval
    :param columns_map: mapping of column names
    :param end: deprecated
    :return: attributes used for detector creation on the basis of CO2 concentration
    """
    def simple_f(value, timestamp):
        return value

    attrs = []
    precision = 2
    for column, new_column_name in columns_map.items():
        for normalize in [False]:
            intervals_before = [x for x in range(20, 901, 20)]
            intervals_after = [x for x in range(15, 181, 15)]

            #
            # linearny posun DifferenceA
            op = FirstDifferenceAttrA(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              normalize=normalize,
                              enable_count=True,
                              prefix='',
                              selected_before=[intervals_before],
                              selected_after=[intervals_after],
                              new_column_name=new_column_name)
            attrs += b + a

            pr = '_linear'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            #
            # linearny posun DifferenceB
            op = FirstDifferenceAttrB(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              normalize=normalize,
                              enable_count=True,
                              prefix='',
                              selected_before=[intervals_before],
                              selected_after=[intervals_after],
                              new_column_name=new_column_name)
            attrs += b + a

            pr = '_linear'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            op = DifferenceBetweenRealLinear(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              window_size_before=20*60, window_size_after=3*60,
                              prefix='',
                              new_column_name=new_column_name)
            attrs += b + a

            pr = '_linear'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            #
            # x^2 posun
            op = FirstDifferenceAttrB(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x for x in range(2, 31, 1)],
                              intervals_after=[x * x for x in range(2, 14, 1)],
                              normalize=normalize,
                              enable_count=True,
                              prefix='_x2',
                              selected_before=[[x * x for x in range(2, 31, 1)]],
                              selected_after=[[x * x for x in range(2, 14, 1)]],
                              new_column_name=new_column_name)
            attrs += b + a

            pr = '_x2'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            #
            # x^3 posun
            op = FirstDifferenceAttrB(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x * x for x in range(2, 10, 1)],
                              intervals_after=[x * x * x for x in range(2, 6, 1)],
                              normalize=normalize,
                              enable_count=True,
                              prefix='_x3',
                              selected_before=[[x * x * x for x in range(2, 10, 1)]],
                              selected_after=[[x * x * x for x in range(2, 6, 1)]],
                              new_column_name=new_column_name)
            attrs += b + a

            pr = '_x3'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            #
            # GrowRate - linearne
            op = GrowthRate(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x for x in range(5, 901, 15)],
                              intervals_after=[x for x in range(5, 181, 15)],
                              value_delay=15, prefix='_step20',
                              new_column_name=new_column_name)
            attrs += b + a
            be, af = op.arithmetic_mean(column, precision, b, a, 'G_linear_step_15')
            attrs += be + af

            # GrowRate - linearne
            op = GrowthRate(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x for x in range(5, 901, 30)],
                              intervals_after=[x for x in range(5, 181, 30)],
                              value_delay=30, prefix='_step_30',
                              new_column_name=new_column_name)
            attrs += b + a
            be, af = op.arithmetic_mean(column, precision, b, a, 'G_linear_step_30')
            attrs += be + af

            # GrowRate - x^2
            op = GrowthRate(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x for x in range(2, 31, 1)],
                              intervals_after=[x * x for x in range(2, 14, 1)],
                              value_delay=30, prefix='_x2',
                              new_column_name=new_column_name)
            attrs += b + a
            be, af = op.arithmetic_mean(column, precision, b, a, 'Grow_x2')
            attrs += be + af

            # GrowRate - x^3
            op = GrowthRate(row_selector, interval_selector, simple_f)
            b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x * x for x in range(2, 10, 1)],
                              intervals_after=[x * x * x for x in range(2, 6, 1)],
                              value_delay=30, prefix='_x3',
                              new_column_name=new_column_name)
            attrs += b + a
            be, af = op.arithmetic_mean(column, precision, b, a, 'Grow_x3')
            attrs += be + af

        op = InOutDiff(row_selector, interval_selector, simple_f)
        b, a = op.execute(timestamp=timestamp, column='co2_in_ppm_diff', precision=precision,
                          intervals_before=[1],
                          intervals_after=[],
                          prefix='',
                          new_column_name=new_column_name)
        attrs += b + a

    return attrs


def func_t_h(timestamp, row_selector, interval_selector, columns_map, end=None):
    """It calculates attributes used for detector creation on the basis of temperature and humidity that
       detects window opening.

    :param timestamp: timestamp when an event occurred
    :param row_selector: selector of row
    :param interval_selector: selector of interval
    :param columns_map: mapping of column names
    :param end: deprecated
    :return: attributes used for detector creation on the basis of temperature and humidity
    """
    attrs = []
    precision = 5

    for column, new_column_name in columns_map.items():
        for normalize in [False]:
            intervals_before = [x for x in range(0, 601, 15)]
            intervals_after = [x for x in range(0, 181, 15)]

            op = FirstDifferenceAttrA(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              normalize=normalize,
                              enable_count=True,
                              prefix='',
                              selected_before=[intervals_before],
                              selected_after=[intervals_after],
                              new_column_name=new_column_name)
            attrs += a + b

            pr = ''
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            op = FirstDifferenceAttrB(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              normalize=normalize,
                              enable_count=True,
                              prefix='',
                              selected_before=[intervals_before],
                              selected_after=[intervals_after],
                              new_column_name=new_column_name)
            attrs += a + b

            pr = 'B_linearne'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            op = SecondDifferenceAttr(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              normalize=normalize,
                              enable_count=True,
                              prefix='',
                              selected_before=[intervals_before],
                              selected_after=[intervals_after],
                              new_column_name=new_column_name)
            attrs += a + b

            op = DifferenceBetweenRealLinear(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              window_size_before=15 * 60, window_size_after=3 * 60,
                              prefix='',
                              new_column_name=new_column_name)
            attrs += a + b

            op = FirstDifferenceAttrB(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x for x in range(4, 25, 1)],
                              intervals_after=[x * x for x in range(4, 14, 1)],
                              normalize=normalize,
                              enable_count=True,
                              prefix='_x2',
                              selected_before=[[x * x for x in range(4, 25, 1)]],
                              selected_after=[[x * x for x in range(4, 14, 1)]],
                              new_column_name=new_column_name)
            attrs += a + b

            pr = 'B_x2'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            op = SecondDifferenceAttr(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x for x in range(4, 25, 1)],
                              intervals_after=[x * x for x in range(4, 14, 1)],
                              normalize=normalize,
                              enable_count=True,
                              prefix='_x2',
                              selected_before=[[x * x for x in range(4, 25, 1)]],
                              selected_after=[[x * x for x in range(4, 14, 1)]],
                              new_column_name=new_column_name)
            attrs += a + b

            op = DifferenceBetweenRealLinear(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              window_size_before=15 * 60, window_size_after=3 * 60,
                              prefix='_x2',
                              new_column_name=new_column_name)
            attrs += a + b

            op = FirstDifferenceAttrB(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x * x for x in range(3, 9, 1)],
                              intervals_after=[x * x * x for x in range(3, 6, 1)],
                              normalize=normalize,
                              enable_count=True,
                              prefix='_x3',
                              selected_before=[[x * x * x for x in range(3, 9, 1)]],
                              selected_after=[[x * x * x for x in range(3, 6, 1)]],
                              new_column_name=new_column_name)
            attrs += a + b

            pr = 'B_x3'
            be, af = op.geometric_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.arithmetic_mean(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.variance(column, precision, b, a, pr)
            attrs += be + af
            be, af = op.standard_deviation(column, precision, b, a, pr)
            attrs += be + af

            op = SecondDifferenceAttr(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=[x * x * x for x in range(3, 9, 1)],
                              intervals_after=[x * x * x for x in range(3, 6, 1)],
                              normalize=normalize,
                              enable_count=True,
                              prefix='_x3',
                              selected_before=[[x * x * x for x in range(3, 9, 1)]],
                              selected_after=[[x * x * x for x in range(3, 6, 1)]],
                              new_column_name=new_column_name)
            attrs += a + b

            op = DifferenceBetweenRealLinear(row_selector, interval_selector)
            a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                              intervals_before=intervals_before,
                              intervals_after=intervals_after,
                              window_size_before=15 * 60, window_size_after=3 * 60,
                              prefix='_x3',
                              new_column_name=new_column_name)
            attrs += a + b

        op = InOutDiff(row_selector, interval_selector)
        b, a = op.execute(timestamp=timestamp, column='temperature_in2_celsius_diff',
                          precision=precision,
                          intervals_before=[0],
                          intervals_after=[],
                          prefix='',
                          new_column_name=new_column_name)
        attrs += b + a

        op = InOutDiff(row_selector, interval_selector)
        b, a = op.execute(timestamp=timestamp, column='rh_in2_specific_g_kg_diff',
                          precision=precision,
                          intervals_before=[0],
                          intervals_after=[],
                          prefix='',
                          new_column_name=new_column_name)
        attrs += b + a

        op = InOutDiff(row_selector, interval_selector)
        b, a = op.execute(timestamp=timestamp, column='rh_in2_absolute_g_m3_diff',
                          precision=precision,
                          intervals_before=[0],
                          intervals_after=[],
                          prefix='',
                          new_column_name=new_column_name)
        attrs += b + a

    return attrs


def func_predict_co2(timestamp, row_selector, interval_selector, columns_map, end=None):
    """It calculates attributes used for predictor creation on the basis of CO2 concentration.

    :param timestamp: timestamp when an event occurred
    :param row_selector: selector of row
    :param interval_selector: selector of interval
    :param columns_map: mapping of column names
    :param end: deprecated timestamp that denotes end of event
    :return: attributes used for predictor creation on the basis of CO2 concentration
    """
    attrs = []
    precision = 2

    for column, new_column_name in columns_map.items():
        intervals_before = [1]
        intervals_after = []

        op = InOutDiff(row_selector, interval_selector)
        b, a = op.execute(timestamp=timestamp, column=column, precision=precision,
                          intervals_before=intervals_before,
                          intervals_after=intervals_after,
                          prefix='',
                          new_column_name=new_column_name)
        attrs += b + a

    model = SimpleExpRegression(350, None)
    op = CO2VentilationLength(row_selector, interval_selector)
    b, a = op.execute(timestamp_start=timestamp, timestamp_end=end,
                      compute_timestamp=5*60, intervals=[], method=model,
                      co2_out=350,
                      column='co2_in_ppm', precision=0, prefix='',
                      enable_actual_value=False)
    attrs += b + a

    if end is not None:

        model = SimpleExpRegression(350, None)
        op = Regression(row_selector, interval_selector, model)
        b, a = op.execute(timestamp_start=timestamp, timestamp_end=end,
                          column='co2_in_ppm', precision=0, prefix='', enable_error=False,
                          new_column_name='co2_in')
        attrs += b + a

    return attrs


def func_predict_t_h(timestamp, row_selector, interval_selector, columns_map, end=None):
    """It calculates attributes used for predictor creation on the basis of temperature and humidity.

    :param timestamp: timestamp when an event occurred
    :param row_selector: selector of row
    :param interval_selector: selector of interval
    :param columns_map: mapping of column names
    :param end: timestamp that denotes end of event
    :return: attributes used for predictor creation on the basis of temperature and humidity
    """
    attrs = []
    precision = 5

    for column, new_column_name in columns_map.items():
        op = InOutDiff(row_selector, interval_selector)
        a, b = op.execute(timestamp=timestamp, column=column, precision=precision,
                          intervals_before=[0],
                          intervals_after=[],
                          prefix='',
                          new_column_name=new_column_name)
        attrs += a + b

        op = InLinear(row_selector, interval_selector)
        a, b = op.execute(timestamp_before=timestamp, timestamp_after=end,
                          column='rh_in2_specific_g_kg', precision=precision,
                          start_before=timestamp - 1200, end_before=timestamp,
                          start_after=end, end_after=end,
                          prefix='',
                          new_column_name='rh_in_specific')
        attrs += a + b

    if end is not None:
        op = InLinear(row_selector, interval_selector)
        a, b = op.execute(timestamp_before=timestamp, timestamp_after=end,
                          column='rh_in2_specific_g_kg', precision=precision,
                          start_before=timestamp, end_before=timestamp,
                          start_after=end, end_after=end + 1200,
                          prefix='',
                          new_column_name='rh_in_specific')
        attrs += a + b

        op = VentilationLength(row_selector, interval_selector)
        a, b = op.execute(event_start=timestamp, event_end=end, intervals=[5*60, 10*60, 25*60],
                          threshold=120, prefix='')
        # all intervals
        # a, b = op.execute(event_start=timestamp, event_end=end, intervals=[5 * 60, 10 * 60, 15 * 60, 20 * 60, 25 * 60],
        # threshold=120, prefix='')
        attrs += a + b

        op = DiffInLinear(row_selector, interval_selector)
        a, b = op.execute(timestamp_before=timestamp, timestamp_after=end,
                          column='rh_in2_specific_g_kg', precision=precision,
                          start_before=timestamp - 1200, end_before=timestamp,
                          start_after=end, end_after=end + 1200,
                          prefix='',
                          new_column_name='rh_in_specific')
        attrs += a

    return attrs
