"""Calculates average slope of multiple lines.
"""
from dm.coefficients.AbstractLineCoefficients import AbstractLineCoefficients
from dm.coefficients.DistanceToLine import DistanceToLine
import numpy as np

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class PolyfitLineAvgSlope(AbstractLineCoefficients):
    def calculate(self, data, interval, col1, col2, col3, point_x, point_y):
        """It calculates average slope of multiple lines.

        It uses the polyfit function from numpy library.

        :param data: training data
        :param interval: interval that denotes a ventilation length (class, cluster)
        :param col1: column name containing values of specific humidity measured when the events started
        :param col2: column name containing values of specific humidity measured when the events finished
        :param col3: column name containing values of differences between indoor and outdoor specific
                     humidity when the events started
        :param point_x: deprecated
        :param point_y: deprecated
        :return: average slope of multiple lines
        """
        direction = []
        for row in DistanceToLine.ventilation_length_events(data, interval):
            sh_decrease_tmp = [0, float(row[col1]) - float(row[col2])]
            sh_diff_tmp = [0, float(row[col3])]
            coeffs_point = np.polyfit(sh_decrease_tmp, sh_diff_tmp, 1)
            direction.append(coeffs_point[0])

        return sum(direction) / float(len(direction))
