"""Calculates average slope of multiple lines.
"""
from dm.coefficients import AbstractLineCoefficients
from dm.coefficients.DistanceToLine import DistanceToLine

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class MathLineAvgSlope(AbstractLineCoefficients):
    def calculate(self, data, interval, col1, col2, col3, point_x, point_y):
        """It calculates average slope of multiple lines.

        :param data: training data
        :param interval: interval that denotes a ventilation length (class, cluster)
        :param col1: column name containing values of specific humidity measured when the events started
        :param col2: column name containing values of specific humidity measured when the events finished
        :param col3: column name containing values of differences between indoor and outdoor specific
                     humidity when the events started
        :param point_x: deprecated
        :param point_y: deprecated
        :return: average slope of multiple lines
        """
        direction = []
        for row in DistanceToLine.ventilation_length_events(data, interval):
            b = -(float(row[col1]) - float(row[col2]))
            a = float(row[col3])
            direction.append(-a / b)

        return sum(direction) / float(len(direction))

