"""Calculates slope of a line passing through a point.
"""
from dm.coefficients.AbstractLineCoefficients import AbstractLineCoefficients

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class CenterLineSlope(AbstractLineCoefficients):
    def calculate(self, data, interval, col1, col2, col3, point_x, point_y):
        """It calculates a slope of a line passing through a point.

        :param data: training data
        :param interval: interval that denotes a ventilation length (class, cluster)
        :param col1: column name containing values of specific humidity measured when the events started
        :param col2: column name containing values of specific humidity measured when the events finished
        :param col3: column name containing values of differences between indoor and outdoor specific
                     humidity when the events started
        :param point_x: x-coordinate of a point (cluster centroid)
        :param point_y: y-coordinate of a point (cluster centroid)
        :return: slope of a line passing through a point
        """
        a = point_y
        b = -point_x

        return -a / b

