"""Abstract class for calculation of CO2 regression using various methods.
"""
from abc import ABC, abstractmethod

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


class AbstractRegression(ABC):
    def __init__(self, co2_out):
        self._co2_out = co2_out
        super(AbstractRegression, self).__init__()

    @abstractmethod
    def compute_parameter(self, x, y):
        """It computes air change rate and its error.

        :param x: list of time points
        :param y: list of CO2 values in given time points
        :return: pair of air change rate and its error
        """
        pass

    @abstractmethod
    def compute_curve(self, x, y):
        """It computes values after exponential regression in given time points.

        :param x: list of time points
        :param y: list of CO2 values in given time points
        :return: list of values after exponential regression calculated in given time points
        """
        pass
