"""Assigns given ventilation length to a class.
"""
from dm.attrs.AbstractPrepareAttr import AbstractPrepareAttr

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class VentilationLength(AbstractPrepareAttr):
    def execute(self, event_start, event_end, intervals, threshold, prefix):
        """It assigns given ventilation length to a class.

        :param event_start: timestamp that denotes the start of the event
        :param event_end: timestamp that denotes the end of the event
        :param intervals: intervals representing classes to which the events can be assigned
        :param threshold: threshold used in evaluation to which class the event should be assigned
        :param prefix: prefix of attribute name
        :return: pair of lists, each list contains pairs of attribute name and assigned
                 interval (class)
        """
        diff = event_end - event_start
        value = None

        for interval in intervals:
            if (interval - threshold) < diff < (interval + threshold):
                value = str(interval)
                break

        if value is None:
            raise ValueError('the value can not be assigned to any class')

        name = self.attr_name('event', prefix, '', '')
        before = [(name, "'" + value + "'")]
        # before = [(name, value)]
        after = []

        return before, after
