"""Calculates second differences using quantity values.
"""
from dm.attrs.FirstDifferenceAttrB import FirstDifferenceAttrB

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


class SecondDifferenceAttr(FirstDifferenceAttrB):
    def execute(self, timestamp, column, precision, intervals_before, intervals_after,
                normalize, enable_count, prefix, selected_before, selected_after,
                new_column_name):
        """It computes the second differences using quantity values.

        :param timestamp: timestamp when event occurred
        :param column: name of column that contains required values
        :param precision: precision of calculation
        :param intervals_before: list of time points before event
        :param intervals_after: list of time points after event
        :param normalize: if the computed should be normalized
        :param enable_count: if number of positives values should be computed
        :param prefix: prefix of attribute name
        :param selected_before: list of lists of selected time points before event
        :param selected_after: list of lists of selected time points after event
        :param new_column_name: name of attribute
        :return: pair of lists, each list contains pairs of attribute name and
                 the second difference
        """
        before, after = super(SecondDifferenceAttr, self).execute(timestamp, column, precision,
                                                                  intervals_before,
                                                                  intervals_after, normalize,
                                                                  False, prefix,
                                                                  selected_before,
                                                                  selected_after,
                                                                  new_column_name)
        before_second = []
        after_second = []

        last_value = before[0][1]
        for k in range(1, len(before)):
            value = before[k][1]

            interval = '{0}and{1}'.format(intervals_before[k - 1], intervals_before[k])
            if normalize:
                name = self.attr_name(new_column_name, prefix, 'norm_before', interval)
            else:
                name = self.attr_name(new_column_name, prefix, 'before', interval)

            derivation = round(last_value - value, precision)
            before_second.append((name, derivation))
            last_value = value

        if len(after) > 0:
            last_value = after[0][1]
        for k in range(1, len(after)):
            value = after[k][1]

            interval = '{0}and{1}'.format(intervals_after[k - 1], intervals_after[k])
            if normalize:
                name = self.attr_name(new_column_name, prefix, 'norm_after', interval)
            else:
                name = self.attr_name(new_column_name, prefix, 'after', interval)

            derivation = round(value - last_value, precision)
            after_second.append((name, derivation))
            last_value = value

        if enable_count:
            b, a = self._compute_increase(new_column_name, intervals_before, intervals_after,
                                          before, after,
                                          selected_before, selected_after, prefix)
            return before + b, after + a

        return before, after
