"""Calculates differences between quantity values measured indoor and outdoor.
"""
from dm.attrs.AbstractPrepareAttr import AbstractPrepareAttr

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class InOutDiff(AbstractPrepareAttr):
    def execute(self, timestamp, column, precision, intervals_before, intervals_after,
                prefix, new_column_name):
        """It computes differences between quantity values measured indoor and outdoor.

        :param timestamp: timestamp when event occurred
        :param column: name of column that contains required values
        :param precision: precision of calculation
        :param intervals_before: list of time points before event
        :param intervals_after: list of time points after event
        :param prefix: prefix of attribute name
        :param new_column_name: name of attribute
        :return: pair of lists, each list contains pairs of attribute name and geometric mean
        """

        before = []
        after = []

        for interval in intervals_before:
            res = round(self.row_selector.row(column, timestamp - interval), precision)
            name = self.attr_name(new_column_name, prefix, 'before', interval)
            before.append((name, res))

        for interval in intervals_after:
            res = round(self.row_selector.row(column, timestamp + interval), precision)
            name = self.attr_name(new_column_name, prefix, 'after', interval)
            before.append((name, res))

        return before, after
