"""Calculates difference between quantity values after linearization (selects linearized values
   at the moment of window opening and closing).
"""
from dm.attrs.InLinear import InLinear

__author__ = 'Klára Nečasová'
__email__ = 'xnecas24@stud.fit.vutbr.cz'


class DiffInLinear(InLinear):
    def execute(self, timestamp_before, timestamp_after, column, precision,
                start_before, end_before, start_after, end_after, prefix,
                new_column_name):
        """It computes difference between quantity values after linearization.

        After linearization time points at the moment of window opening and
        window closing are selected to compute difference.

        :param timestamp_before: timestamp selected from linearized time interval before event
        :param timestamp_after: timestamp selected from linearized time interval after event
        :param column: name of column that contains required values
        :param precision: precision of calculation
        :param start_before: time shift before event that denotes start of time interval
                             that is linearised (in seconds)
        :param end_before: time shift before event that denotes end of time interval
                           that is linearised (in seconds)
        :param start_after: time shift after event that denotes start of time interval
                            that is linearised (in seconds)
        :param end_after: time shift after event that denotes end of time interval
                          that is linearised (in seconds)
        :param prefix: prefix of attribute name
        :param new_column_name: name of attribute
        :return: pair of lists, the first list contains pair including attribute name
                 and difference between quantity values after linearization
        """
        b, a = super(DiffInLinear, self).execute(timestamp_before, timestamp_after,
                                                 column, precision,
                                                 start_before, end_before,
                                                 start_after, end_after, prefix,
                                                 new_column_name)

        name = self.attr_name(new_column_name, prefix, 'before', '')
        before = [(name, round(b[0][1] - a[0][1], 2))]

        return before, []
