"""Gets current value CO2 and measured value CO2 in a given time point.
"""
from dm.attrs.AbstractPrepareAttr import AbstractPrepareAttr
from sympy import *

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


class CO2VentilationLength(AbstractPrepareAttr):
    def execute(self, timestamp_start, timestamp_end, compute_timestamp, intervals,
                method, co2_out, column, precision, prefix, enable_actual_value=True):
        """It computes how long ventilation was performed to decrease a CO2 concentration.

        :param timestamp_start: timestamp when ventilation started
        :param timestamp_end: timestamp when ventilation finished
        :param compute_timestamp: selected timestamp during ventilation
        :param intervals: deprecated
        :param method: deprecated
        :param co2_out: concentration of outside CO2
        :param column: name of column that contains required values
        :param precision: precision of calculation
        :param prefix: prefix of attribute name
        :param enable_actual_value: if the actual value should be included in output
        :return: pair of lists, the first list contains at most two pairs,
                 the first one (optional) includes attribute name and actual value,
                 the second one includes attribute name and ventilation length
        """

        if timestamp_end is None:
            return [('co2_start', self.row_selector.row(column, timestamp_start))], []

        x = []
        y = []
        for timestamp in range(timestamp_start, timestamp_end):
            y.append(self.row_selector.row(column, timestamp))
            x.append(timestamp - timestamp_start)

        if enable_actual_value:
            return [('actual_value', y[compute_timestamp]), ('co2_start', y[0])], []

        return [('co2_start', y[0])], []
