"""Utils that contain simple SQL queries.
"""

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


class SQLUtil:
    @staticmethod
    def select_interval_size(table_name: str, start: int, end: int, column: str):
        """It finds out number of records on the basis of given time interval.

        :param table_name: name of table
        :param start: timestamp that denotes start of a time interval
        :param end: timestamp that denotes end of a time interval
        :param column: name of column
        :return: SQL query
        """

        sql = 'SELECT COUNT(*) FROM ' + table_name
        sql += ' WHERE measured_time >= ' + str(start)
        sql += ' and measured_time <= ' + str(end)
        sql += ' and ' + column + ' IS NOT NULL'

        return sql

    @staticmethod
    def select_interval(table_name: str, start: int, end: int, columns: str):
        """It selects given columns from a table on the basis of given time interval.

        :param table_name: name of table
        :param start: timestamp that denotes start of a time interval
        :param end: timestamp that denotes end of a time interval
        :param columns: names of columns
        :return: SQL query
        """

        sql = 'SELECT ' + columns + ' FROM ' + table_name
        sql += ' WHERE measured_time >= ' + str(start)
        sql += ' and measured_time <= ' + str(end)

        return sql

    @staticmethod
    def select_one_value(table_name: str, measured_time: int, columns: str):
        """It selects one record from a table on the basis of given timestamp.

        :param table_name: name of table
        :param measured_time: timestamp that is used to select a record
        :param columns: list of columns that are selected
        :return: SQL query
        """

        sql = 'SELECT ' + columns + ' FROM ' + table_name
        sql += ' WHERE measured_time = ' + str(measured_time)

        return sql
