"""Runs detector or more detectors.
"""
from dm.ConnectionUtil import ConnectionUtil
from dm.Performance import Performance
from os.path import abspath
from subprocess import run

__author__ = 'Peter Tisovčík'
__email__ = 'xtisov00@stud.fit.vutbr.cz'


class ExampleRunner:
    @staticmethod
    def detector(before, after, script_name, process, enable_training):
        """It runs a process in RapidMiner.

        :param before: time shift before start of event
        :param after: time shift after start of event
        :param script_name: name of script
        :param process: name of RapidMiner process
        :param enable_training: if training phase should be performed
        :return: None
        """
        launcher = ConnectionUtil.rapid_miner()['launcher']

        if enable_training:
            run(['python3', script_name], universal_newlines=True)

        run([launcher, process], universal_newlines=True)

        p = Performance(abspath('out.csv'))

        table, _, _ = p.simple()
        print(table)

        table, wrong, _ = p.with_delay(before, after)
        print(table)

        for row in wrong:
            print(row)

        run(['notify-send', 'PyCharm', 'End of generation'])

    @staticmethod
    def feature_stats(script_name, enable_training):
        """It runs computing of statistics.

        :param script_name: name of script
        :param enable_training: if training phase should be performed
        :return: None
        """
        if enable_training:
            run(['python3', script_name], universal_newlines=True)

        run(['python3', 'feature_stats.py'], universal_newlines=True)
        run(['notify-send', 'PyCharm', 'End of generation'])
