# Docker Infrastructure for TARZAN Platform: Technical Documentation

(c) 2019-2020 Marek Rychly (rychly@fit.vutbr.cz)

## Utilized Technologies

### Distributed Computing

*	[Apache Spark](https://spark.apache.org/docs/latest/) -- batch and stream processing
*	[Apache Hadoop](https://hadoop.apache.org/docs/current/) -- MapReduce batch processing, a platform base

### Data Storage

*	[Apache Cassandra](https://cassandra.apache.org/doc/latest/) -- a NoSQL database
*	[Apache HDFS](https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-hdfs/HdfsUserGuide.html) -- a file-system

### Communication

*	[Apache Kafka](https://kafka.apache.org/documentation.html) -- a message queue broker

### API / Development Tools

*	[Apache Livy](https://livy.incubator.apache.org/docs/latest/) -- REST API for Apache Spark
*	[Apache Zeppelin](https://zeppelin.apache.org/docs/) -- Web UI for various distributed computation/data processing interpreters and data visualisation
*	[Halyard SDK and WebApps](https://github.com/Merck/Halyard) -- horizontally scalable triple store with support for named graphs
*	[Plaso](https://github.com/log2timeline/plaso) -- tools for automatic creation of timelines to support digital forensic investigators/analysts
*	[Timeline Analyzer](https://github.com/nesfit/timeline-analyzer) -- a framework for efficient analysis of social network profiles and other related data

## Acknowledgements

*This work was supported by the Ministry of the Interior of the Czech Republic as a part of the project Integrated platform for analysis of digital data from security incidents VI20172020062.*
