/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.tshark.java;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.ndx.model.Packet;
import org.ndx.model.json.JsonPacket;
import org.ndx.model.pcap.PacketModel;
import org.ndx.model.pcap.PcapPacket;
import org.ndx.pcap.PcapInputFormat;
import scala.Tuple2;

public class TShark {
    private static final Log LOG = LogFactory.getLog(TShark.class);
    private static final String PCAP = "pcap";
    private static final String CAP = "cap";
    private static final String JSON = "json";

    private static JavaRDD<Packet> readInputFiles(JavaSparkContext sc, String path) throws IOException {
        JavaRDD<Packet> packets;
        switch (FilenameUtils.getExtension((String)path)) {
            case "pcap": 
            case "cap": {
                packets = TShark.pcapToPacket(sc, path);
                break;
            }
            case "json": {
                packets = TShark.jsonToPacket(sc, path);
                break;
            }
            default: {
                throw new IOException("Not supported input file format.");
            }
        }
        return packets;
    }

    private static JavaRDD<Packet> jsonToPacket(JavaSparkContext sc, String path) {
        JavaPairRDD lines = sc.newAPIHadoopFile(path, TextInputFormat.class, LongWritable.class, Text.class, new Configuration());
        JavaRDD jsons = lines.filter((Function & Serializable)x -> ((Text)x._2).toString().startsWith("{\"timestamp")).map((Function & Serializable)x -> ((Text)x._2).toString());
        return jsons.map((Function & Serializable)jsonFrame -> {
            JsonPacket packet = new JsonPacket();
            ((Packet)packet).parsePacket((String)jsonFrame);
            return packet;
        });
    }

    private static JavaRDD<Packet> pcapToPacket(JavaSparkContext sc, String path) {
        JavaPairRDD frames = sc.hadoopFile(path, PcapInputFormat.class, LongWritable.class, ObjectWritable.class);
        return frames.map((Function & Serializable)pcapFrame -> {
            PcapPacket packet = new PcapPacket();
            ((Packet)packet).parsePacket((PacketModel.RawFrame)((ObjectWritable)pcapFrame._2).get());
            return packet;
        });
    }

    public static JavaRDD<Packet> getPackets(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets;
        try {
            packets = TShark.readInputFiles(sc, path);
        }
        catch (IOException e) {
            LOG.error("Not supported input file format.");
            return null;
        }
        return packets;
    }

    public static JavaPairRDD<String, Iterable<Packet>> getFlows(JavaSparkContext sc, String path) {
        JavaRDD<Packet> packets = TShark.getPackets(sc, path);
        return packets != null ? packets.mapToPair((PairFunction & Serializable)x -> new Tuple2((Object)x.getFlowString(), x)).groupByKey() : null;
    }
}

