/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.parsers.applayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ndx.model.Packet;
import org.ndx.model.json.JsonAdapter;
import org.ndx.model.json.JsonHelper;
import org.ndx.model.parsers.applayer.AppLayerParser;

public class HttpJsonParser
extends AppLayerParser {
    private static final Log LOG = LogFactory.getLog(HttpJsonParser.class);
    private static final String HTTP_JSON_REQUEST = "http_http_request";
    private static final String HTTP_JSON_RESPONSE = "http_http_response";
    private static final String HTTP_JSON_VERSION = "text_http_request_version";
    private static final String HTTP_JSON_METHOD = "text_http_request_method";
    private static final String HTTP_JSON_HOST = "http_http_host";

    public HttpJsonParser(int packetNo) {
        this.packetNumber = packetNo;
    }

    public HttpJsonParser() {
    }

    public void parse(JsonAdapter payload) {
        boolean isRequest = payload.containsKey(HTTP_JSON_REQUEST);
        boolean isResponse = payload.containsKey(HTTP_JSON_RESPONSE);
        if (isRequest) {
            this.put("http_is_response", false);
            JsonHelper.addValue(this.packetNumber, this, "http_url", payload, HTTP_JSON_HOST, JsonHelper.ValueTypes.STRING);
            JsonHelper.addValue(this.packetNumber, this, "http_method", payload, HTTP_JSON_METHOD, JsonHelper.ValueTypes.STRING);
            JsonHelper.addValue(this.packetNumber, this, "http_version", payload, HTTP_JSON_VERSION, JsonHelper.ValueTypes.STRING);
        } else if (isResponse) {
            this.put("http_is_response", true);
            JsonHelper.addValue(this.packetNumber, this, "http_version", payload, HTTP_JSON_VERSION, JsonHelper.ValueTypes.STRING);
        } else {
            LOG.warn((Object)(Packet.getLogPrefix(this.packetNumber) + "Http packet is neither a request nor a response."));
        }
    }
}

