/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model.parsers.applayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.ndx.model.parsers.applayer.AppLayerParser;
import org.ndx.model.parsers.applayer.DnsHelper;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;

public class DnsPcapParser
extends AppLayerParser {
    private static final int PCAP_DNS_COUNT_QUERIES = 0;
    private static final int PCAP_DNS_COUNT_ASWERS = 1;
    private static final int PCAP_DNS_QUERY_SECTION = 0;
    private static final int PCAP_DNS_ANSWER_SECTION = 1;
    private static final int PCAP_DNS_QR_FLAG = 0;

    public void parse(byte[] payload) throws IllegalArgumentException {
        try {
            Message dnsMsg = new Message(payload);
            Header dnsHeader = dnsMsg.getHeader();
            this.put("dns_id", dnsHeader.getID());
            this.put("dns_query_cnt", dnsHeader.getCount(0));
            this.put("dns_answer_cnt", dnsHeader.getCount(1));
            this.put("dns_query_response", dnsHeader.getFlag(0));
            this.put("dns_queries", this.parseSection(dnsMsg.getSectionArray(0)));
            this.put("dns_answers", this.parseSection(dnsMsg.getSectionArray(1)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ArrayList<String> parseSection(Record[] section) {
        String[] records = (String[])Arrays.stream(section).map(record -> DnsHelper.formatOutput(record.getName().toString(true), Integer.toString(record.getType()), Integer.toString(record.getDClass()), record.rdataToString())).toArray(String[]::new);
        return new ArrayList<String>(Arrays.asList(records));
    }
}

