/*
 * Decompiled with CFR 0.152.
 */
package org.ndx.model;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ndx.model.Packet;
import org.ndx.model.pcap.ConversationModel;
import org.ndx.model.pcap.FlowModel;

public class Statistics {
    private static final Log LOG = LogFactory.getLog(Statistics.class);
    private static final long MILISECONDS_TO_SECONDS = 1000L;
    private static DecimalFormat df = new DecimalFormat("#.###");

    public static Date ticksToDate(long ticks) {
        return new Date(ticks);
    }

    public static double timestampToSeconds(long timestamp) {
        return (double)timestamp / 1000.0;
    }

    public static Map<String, Integer> mergeMaps(Map<String, Integer> map1, Map<String, Integer> map2) {
        map2.forEach((k, v) -> map1.merge((String)k, (Integer)v, (v1, v2) -> v1 + v2));
        return map1;
    }

    public static String lanOrWan(String srcIp, String dstIp) {
        String lanWan = "wan";
        try {
            if (Statistics.ipAddrPrivate(srcIp) && Statistics.ipAddrPrivate(dstIp)) {
                lanWan = "lan";
            }
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)"Input string is not an ip address.");
            lanWan = "";
        }
        return lanWan;
    }

    private static boolean ipAddrPrivate(String ip) throws UnknownHostException {
        boolean isPrivate = false;
        InetAddress address = InetAddress.getByName(ip);
        if (address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isMCLinkLocal() || address.isMCNodeLocal() || address.isMCOrgLocal() || address.isMCSiteLocal()) {
            isPrivate = true;
        }
        if (address instanceof Inet4Address && address.isSiteLocalAddress()) {
            isPrivate = true;
        }
        return isPrivate;
    }

    public static String getEmailProtocol(String srcPort, String dstPort) {
        String email = "";
        if (srcPort.equals(Integer.toString(110)) || dstPort.equals(Integer.toString(110))) {
            email = "pop3";
        } else if (srcPort.equals(Integer.toString(143)) || dstPort.equals(Integer.toString(143))) {
            email = "imap";
        } else if (srcPort.equals(Integer.toString(25)) || dstPort.equals(Integer.toString(25)) || srcPort.equals(Integer.toString(587)) || dstPort.equals(Integer.toString(587))) {
            email = "smtp";
        } else if (srcPort.equals(Integer.toString(995)) || dstPort.equals(Integer.toString(995))) {
            email = "spop3";
        } else if (srcPort.equals(Integer.toString(993)) || dstPort.equals(Integer.toString(993))) {
            email = "imaps";
        } else if (srcPort.equals(Integer.toString(465)) || dstPort.equals(Integer.toString(465))) {
            email = "smtps";
        }
        return email;
    }

    public static String getService(String srcPort, String dstPort) {
        String port = "";
        try {
            port = Integer.parseInt(srcPort) < Integer.parseInt(dstPort) ? srcPort : dstPort;
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"Given port is not a number.");
        }
        return port;
    }

    public static String getDirection(String srcPort, String dstPort) {
        String direction = "";
        try {
            direction = Integer.parseInt(srcPort) < Integer.parseInt(dstPort) ? "down" : "up";
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"Given port is not a number.");
        }
        return direction;
    }

    public static ConversationModel.FlowAttributes merge(ConversationModel.FlowAttributes x, ConversationModel.FlowAttributes y) {
        ConversationModel.FlowAttributes.Builder builder = ConversationModel.FlowAttributes.newBuilder();
        builder.setFirstSeen(Math.min(x.getFirstSeen(), y.getFirstSeen()));
        builder.setLastSeen(Math.max(x.getLastSeen(), y.getLastSeen()));
        builder.setPackets(x.getPackets() + y.getPackets());
        builder.setOctets(x.getOctets() + y.getOctets());
        builder.setMaximumPayloadSize(Math.max(x.getMaximumPayloadSize(), y.getMaximumPayloadSize()));
        builder.setMinimumPayloadSize(Math.min(x.getMinimumPayloadSize(), y.getMinimumPayloadSize()));
        builder.setMeanPayloadSize((x.getMeanPayloadSize() + y.getMeanPayloadSize()) / 2);
        return builder.build();
    }

    public static ConversationModel.FlowAttributes fromPacket(Packet p) {
        Long first = 0L;
        Long last = 0L;
        Long octets = 0L;
        if (p.containsKey("ts")) {
            first = ((Number)p.get("ts")).longValue();
            last = ((Number)p.get("ts")).longValue();
        }
        if (p.containsKey("frame_len")) {
            octets = ((Number)p.get("frame_len")).longValue();
        }
        ConversationModel.FlowAttributes.Builder builder = ConversationModel.FlowAttributes.newBuilder();
        builder.setFirstSeen(first);
        builder.setLastSeen(last);
        builder.setPackets(1);
        builder.setOctets(octets);
        builder.setMaximumPayloadSize(octets.intValue());
        builder.setMinimumPayloadSize(octets.intValue());
        builder.setMeanPayloadSize(octets.intValue());
        return builder.build();
    }

    public static String format(String flowkey, ConversationModel.FlowAttributes attributes) {
        Date first = Statistics.ticksToDate(attributes.getFirstSeen());
        Date last = Statistics.ticksToDate(attributes.getLastSeen());
        float diff = (float)(last.getTime() - first.getTime()) / 1000.0f;
        FlowModel.FlowKey fkey = Packet.flowKeyParse(flowkey);
        String fkeystr = String.format("%5s %20s -> %20s ", fkey.getProtocol().toStringUtf8(), fkey.getSourceAddress().toStringUtf8() + ":" + fkey.getSourceSelector().toStringUtf8(), fkey.getDestinationAddress().toStringUtf8() + ":" + fkey.getDestinationSelector().toStringUtf8());
        return String.format("%30s %12s %60s %10d %15d %5d", first.toString(), df.format(diff), fkeystr, attributes.getPackets(), attributes.getOctets(), 1);
    }
}

