/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.communication.service.handler;

import cz.vutbr.fit.communication.command.Command;
import cz.vutbr.fit.communication.service.handler.ICommandHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerManager<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerManager.class);
    private Map<Command, ICommandHandler<K, V>> handlers = new HashMap<Command, ICommandHandler<K, V>>();

    public void handle(Command command, K key, V value) {
        ICommandHandler<K, V> handler = this.handlers.get((Object)command);
        if (handler == null) {
            this.handleError(command, key);
        } else {
            handler.handleRequest(key, value);
        }
    }

    public void attachHandler(Command command, ICommandHandler<K, V> handler) {
        this.handlers.put(command, handler);
    }

    public void detachHandler(Command command, ICommandHandler<K, V> handler) {
        this.handlers.remove((Object)command, handler);
    }

    private void handleError(Command command, K request) {
        String errorMsg = String.format("Command %s is not supported, request will not be handled %s", new Object[]{command, request});
        LOGGER.error(errorMsg);
    }
}

