TARGET = hloc
TEMPLATE = app
mac:CONFIG-=app_bundle
include($$PWD/../../paths.pri)

QMAKE_CXXFLAGS_DEBUG -= -O0
QMAKE_CXXFLAGS_DEBUG -= -O1
QMAKE_CXXFLAGS_DEBUG -= -O2
QMAKE_CXXFLAGS_DEBUG -= -O3
QMAKE_CXXFLAGS_DEBUG += -O0
QMAKE_CXXFLAGS_DEBUG += -DDEBUG

QMAKE_CXXFLAGS_RELEASE -= -O0
QMAKE_CXXFLAGS_RELEASE -= -O1
QMAKE_CXXFLAGS_RELEASE -= -O2
QMAKE_CXXFLAGS_RELEASE -= -O3
QMAKE_CXXFLAGS_RELEASE += -O3
QMAKE_CXXFLAGS_RELEASE += -DNDEBUG

## OUR SOURCES
INCLUDEPATH += ../../include/hloc
INCLUDEPATH += ../../include/argumentparser
INCLUDEPATH += ../../include/imgproc
INCLUDEPATH += ../../include/thirdparty/terrain
INCLUDEPATH += ../../include/utils

SOURCES+=   ../../src/hloc/BOWQueryResult.cpp \
            ../../src/hloc/Contourlett.cpp \
            ../../src/hloc/ContourlettExtractor.cpp \
            ../../src/hloc/DatabaseEntry.cpp \
            ../../src/hloc/ResultInfo.cpp \
            ../../src/hloc/fieldofviewutil.cpp \
            ../../src/imgproc/Convolution.cpp \
            ../../src/imgproc/GaussianSampler.cpp \
            ../../src/imgproc/Image.cpp \
            ../../src/thirdparty/terrain/PlaceSet.cpp \
            main.cpp

HEADERS+=   ../../include/argumentparser/argument.h         \
            ../../include/argumentparser/argumentparser.h   \
            ../../include/argumentparser/argumentstore.h    \
            ../../include/argumentparser/parameter.h        \
            ../../include/hloc/InversedIndex.h		    \
            ../../include/hloc/BOWDatabase.h                \
            ../../include/hloc/BOWQueryResult.h             \
            ../../include/hloc/Contourlett.h                \
            ../../include/hloc/ContourlettExtractor.h       \
            ../../include/hloc/DatabaseEntry.h              \
            ../../include/hloc/LocalFeature.h               \
            ../../include/hloc/Persistable.h                \
            ../../include/hloc/ResultInfo.h                 \
            ../../include/hloc/fieldofviewutil.h            \
            ../../include/imgproc/Convolution.h             \
            ../../include/imgproc/GaussianSampler.h         \
            ../../include/imgproc/Image.h                   \
            ../../include/thirdparty/terrain/PlaceSet.h     \
            ../../include/utils/XMLUtil.h                   \
#            ../../include/utils/Image2D.h                   \
#            ../../include/utils/ColorTypes.h                \


##THIRD PARTY
INCLUDEPATH +=  /usr/local/include \
                /usr/local/include/libxml2 \
                /usr/include/libxml2 \
                /usr/local/include/eigen3

LIBS += -lboost_filesystem -lboost_system -lboost_serialization
LIBS += -L/usr/local/lib/ -lpng16 -lz -lxml2 -lqjson-qt5

macx:LIBS += $$system(/usr/local/bin/pkg-config --libs libpointmatcher)
else:unix:LIBS += -L/usr/local/lib -lpointmatcher -lGLU

macx:{
    system(/usr/local/bin/pkg-config libhttpserver --exists){
        message("Libhttpserver library found, configuring to be able to use as http service")
        LIBS *= -L/usr/local/lib -lhttpserver -lz
        DEFINES += "USE_LIBHTTPSERVER"
        SOURCES+=   ../../src/hloc/stringzip.cpp \
                    ../../src/hloc/bytearray.cpp
        HEADERS += \
                    ../../include/hloc/stringzip.h                  \
                    ../../include/hloc/bytearray.h

    }
}
else:unix{
    system(pkg-config libhttpserver --exists){
        message("Libhttpserver library found, configuring to be able to use as http service")
        LIBS *= -lhttpserver -lz
        DEFINES += "USE_LIBHTTPSERVER"
        SOURCES+=   ../../src/hloc/stringzip.cpp \
                    ../../src/hloc/bytearray.cpp
        HEADERS += \
                    ../../include/hloc/stringzip.h                  \
                    ../../include/hloc/bytearray.h

    }
}

CONFIG += c++11
CONFIG += dynamic

QT += core widgets concurrent xml gui


