/**
 *  Author: Martin Čadík <cadik@fit.vutbr.cz>
 *          Lionel Baboud
 *          Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "EulerZYZ.h"
#include <math.h>

namespace {
    float inZero2Pi(float a) {
        while (a < 0)       a += 2 * M_PI;
        while (a >= 2*M_PI) a -= 2 * M_PI;
        return a;
        }
    }



Matrix3f EulerZYZ::matrix(float alpha, float beta, float gamma) {
    return EulerZYZ::rotationZ<float>(alpha)
            * EulerZYZ::rotationY<float>(beta)
            * EulerZYZ::rotationZ<float>(gamma);
    }

Matrix3d EulerZYZ::matrixD(double alpha, double beta, double gamma) {
    return EulerZYZ::rotationZ<double>(alpha)
            * EulerZYZ::rotationY<double>(beta)
            * EulerZYZ::rotationZ<double>(gamma);
    }

Matrix3f EulerZYZ::matrix(const Vector3f &angles) {
    return matrix(angles.x(), angles.y(), angles.z());
    }

Matrix3d EulerZYZ::matrixD(const Vector3d &angles) {
    return matrixD(angles.x(), angles.y(), angles.z());
    }

Vector3f EulerZYZ::angles(Matrix3f R) {
    float alpha, beta, gamma;
    angles(R, alpha, beta, gamma);
    return Vector3f(alpha, beta, gamma);
    }
        
void EulerZYZ::angles(Matrix3f Rref, float &alpha, float &beta, float &gamma) {
    //@@ to make more robust
    // http://www.cgafaq.info/wiki/Euler_angles_from_matrix
    // http://en.wikipedia.org/wiki/Euler_angles
    Matrix3f R = Rref;
    
    //Vec3 Y1 = (R * Vec3(0,1,0));
    //MSG_DEBUG_VAR(inZero2Pi(atan2(-Y1.x, Y1.y)));
    //Vec3 Z1 = (R * Vec3(0,0,1));
    //MSG_DEBUG_VAR(inZero2Pi(asinf(vec(Vec3(0,0,1),Z1).norm())));
    
    Vector3f A = -(R * Vector3f(0,0,1)).cross(Vector3f(0,0,1));
    if (A.norm() < 1e-15)
        gamma = 0.0;
        //a = atan2();
    else {
        //Vec3 C = R * Vec3(0,1,0);
        //@@ cas C // (0,0,1)
        //a = atan2(B.)
        A = R.inverse() * A;
        gamma = -atan2(-A.x(), A.y());
        }
    gamma = inZero2Pi(gamma);
    
    //MSG_DEBUG_VAR(R * Vec3(0,1,0));
    //R = Matrix3::rotationZ(-alpha) * R;
    R = R * EulerZYZ::rotationZ<float>(-gamma);
    //MSG_DEBUG_VAR(R * Vec3(0,1,0));
    
    A = R.inverse() * Vector3f(0,0,1);
    beta = -atan2(A.x(), A.z());
    beta = inZero2Pi(beta);             //@@@ to check : beta must be in [0,pi]
    R = R * EulerZYZ::rotationY<float>(-beta);
    
    A = R * Vector3f(1,0,0);
    alpha = atan2(A.y(), A.x());    // + 2 * M_PI;
    alpha = inZero2Pi(alpha);
    //MSG_DEBUG_VAR(R.toQS());
    //R = R * Matrix3::rotationZ(-alpha);
    }
        

