/**
 *  GaussianSampler.cpp
 *
 *  Created on: 26.10.14.
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "GaussianSampler.h"

void GaussianSampler::gaussian1D(float mi, float sigma, unsigned int size, float *kernel)
{
	if (sigma < 0)
		throw std::runtime_error("Standard deviation sigma has to be greater \
								 than 0.");
    /* new correct code*/
	const float e = std::exp(1.0);
	const float PI2sq = sqrt(2 * M_PI);
	const float a = 1/(sigma * PI2sq);
	const float sigma2sq = 2 * (sigma * sigma);
	double x_mi = 0.0;
    float gaus = 0.0;
    float delta = 3 * sigma;
    float sample_size = 2 * delta / (float)size;
    float x = mi - delta;
    unsigned int index = 0;
    while (index < size)
	{
		x_mi = x - mi;
		gaus = a * pow(e, (-((x_mi*x_mi)/(sigma2sq))));
        kernel[index++] = gaus;
        x += sample_size;
	}

    //calculate norm

    float norm = 0.0;
    for (unsigned int i = 0; i < size; ++i)
    {
        norm += kernel[i];
    }
    //normalize
    for (unsigned int i = 0; i < size; ++i)
    {
        kernel[i] /= norm;
    }


    /** orig wrong code */
    /*
    const float e = std::exp(1.0);
    const float PI2sq = sqrt(2 * M_PI);
    const float a = 1/(sigma * PI2sq);
    const float sigma2sq = 2 * (sigma * sigma);
    double x_mi = 0.0;
    float gaus = 0.0;
    const float step = 0.001;

    float delta = 3 * sigma;
    float sample_size = 2 * delta / (float)size;
    float x = mi - delta;
    float c = 0.0;
    int index = 0;
    kernel[0] = 0.0;
    while (x <= mi + delta)
    {
        if (c > sample_size)
        {
            c = 0.0;
            kernel[++index] = 0.0;
        }
        x_mi = x - mi;
        gaus = a * pow(e, (-((x_mi*x_mi)/(sigma2sq))));
        kernel[index] += gaus;
        x += step;
        c += step;
    }

    //normalize to have corners == 1
    /*float coef = 1.0/kernel[0];
    for (int i = 0; i < size; ++i)
    {
        kernel[i] = (int)round(kernel[i] * coef);
    }

    //calculate eucleidian norm
    float norm = 0.0;
    for (int i = 0; i < size; ++i)
    {
        norm += kernel[i];
    }
    //norm = sqrt(norm);
    for (int i = 0; i < size; ++i)
    {
        kernel[i] /= norm;
    }*/
}



