/**
 *  fieldofviewutil.cpp
 *
 *  Created on: 22/06/2016
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
*/
#include "fieldofviewutil.h"
#include <QDebug>

FieldOfViewUtil::FieldOfViewUtil(QString imagePath, float FOV, int panoWidth)
    :image(imagePath), FOV(FOV), panoWidth(panoWidth)
{

}

FieldOfViewUtil::FieldOfViewUtil(QImage image, float FOV, int panoWidth)
    :image(image), FOV(FOV), panoWidth(panoWidth)
{

}


QImage FieldOfViewUtil::fitToFOV()
{
    float imgsize = max(image.width(), image.height());
    double sfactor = ((double)panoWidth/360.0f) / (imgsize/FOV);
    if (std::isnan(sfactor) || std::isinf(sfactor))
    {
        throw runtime_error("Wrong FOV - rescaled image is infinitely large.");
    }
    qDebug() << "sfactor: " << sfactor << ", width: " << image.width() << ", scaled width: " << image.width() * sfactor << ", FOV: " << FOV; 
    return image.scaled(image.width() * sfactor,
                        image.height() * sfactor,
                        Qt::KeepAspectRatio,
                        Qt::SmoothTransformation);
}
