#!/bin/bash
#author: Jan Brejcha

source paths.sh

if [ $# -ne 2 ]; then
	echo "Usage: $0 <result_file.txt> <output dir>"
	echo "<result_file.txt> is text file containing stdout from hloc -f (find-pose)."
	echo "Each line contains result for one query. The whole file will be parsed and "
	echo "for each query the rotation matrix will be created and saved in xml "
	echo "format to the output directory."
	exit 0
fi

input_file=$1
output_dir=$2

if [ ! -f $output_dir ]; then
	mkdir -p $output_dir
fi
for i in $(cat $input_file | sed 's| ||g'); do 
	n=$(basename $(echo $i | cut -f 2 -d \ ) | sed 's|_crop.*||' | sed 's|\.png.*||')
	ypr=$(echo $i | grep -o "ypr:.*" | cut -f 2 -d: | sed 's|,| |g')
	$c2gdist -atm $ypr $output_dir/${n}.xml
done
