#!/bin/bash
#author: Jan Brejcha

source paths.sh

if [ $# -ne 3 ]; then
	echo "Usage: $0 <query_dir> <pano_dir> <fov_database>"
	echo "Finds pose of the query image using corresponding panorama image."
	echo "<query_dir> contains query images,"
	echo "<pano_dir> contains panorama images,"
	echo "both query and pano image should have the same name."
	echo "FOV database is list containing query name and field-of-view divided by space,"
	echo "each query on a single line."
	exit 0
fi

query_dir=$1
pano_dir=$2
fov_database=$3

for i in $(ls $query_dir); do
	n=${i%.*}; fov=$(cat $fov_database | grep $n | cut -f 2 -d\ );
	$hloc -f $pano_dir/$i $query_dir/$i $fov 2>/dev/null
done
