#!/bin/bash
#author: Jan Brejcha

source paths.sh

if [ $# -ne 3 ]; then
	echo "Usage: $0 <dataset dir> <query subdir> <result dir>"
	echo "<dataset dir> is directory containing subdirectories with panoramas,"
	echo "queries, field-of-view database file, and groundtruth."
	echo "<query subdir> is subdirectory in <dataset dir> in which the "
	echo "query files are located."
	echo "<result dir> is directory into which the result files and rotation "
	echo "error file will be stored."
	exit 0;
fi

dataset_dir=$1
query_dir=$2
result_dir=$3

#derived vars
dataset_name=$(basename $dataset_dir)

#run hloc
mkdir -p $result_dir/$dataset_name
./hloc_find_pose.sh $dataset_dir/$query_dir $dataset_dir/allsegment_pano $dataset_dir/fov.txt 2>/dev/null > $result_dir/$dataset_name/hloc_${query_dir}.txt

#yaw pitch roll to rotation matrix
./hloc_ypr_to_rotm.sh $result_dir/$dataset_name/hloc_${query_dir}.txt $result_dir/$dataset_name/hloc_${query_dir}

#measure rotation error
./hloc_dist.sh $dataset_dir/groundtruth $result_dir/$dataset_name/hloc_${query_dir} 2>/dev/null > $result_dir/$dataset_name/hloc_${query_dir}_dist.txt
