#!/bin/bash
#author: Jan Brejcha

source paths.sh

if [ $# -ne 2 ]; then
	echo "Usage: $0 <ground-truth dir> <result dir>"
	echo "<ground-truth-dir> contains ground truth rotation matrices in xml format named by query name."
	echo "<result dir> contains rotation matrices in xml format named by query name."
	exit 0; 
fi

gt_dir=$1
result_dir=$2

for i in $(ls $result_dir); do 
	 $c2gdist -edm $gt_dir/${i%.*}_C2G.xml $($c2gdist -ea $result_dir/$i 2>/dev/null)
done

