/**
 *  XMLUtil.h
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2018  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef XMLUTIL_H
#define XMLUTIL_H

#include <QDomDocument>
#include <QString>
#include <QFile>
#include <QIODevice>

#include <stdexcept>


#define XML_ELEMENT_NAME "Object"

class XMLUtil {
public:
    static QDomDocument loadQDomDocFromFile(QString fileName)
    {
        QFile f(fileName);
        if (!f.open(QIODevice::ReadOnly | QIODevice::Text))
        {
            throw std::runtime_error("Unable to load xml file: "
                                     + fileName.toStdString());
        }
        QDomDocument doc;
        if (!doc.setContent(&f))
        {
            f.close();
            throw std::runtime_error("Unable to read xml file: "
                                     + fileName.toStdString());
        }
        return doc;
    }
};

#endif // XMLUTIL_H
