/**
 *  Author: Martin Čadík <cadik@fit.vutbr.cz>
 *          Lionel Baboud
 *          Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef __EULER_ZYZ__
#define __EULER_ZYZ__

#include <cmath>

#include <Eigen/Dense>

using namespace Eigen;

class EulerZYZ {
    public:
        static Matrix3f matrix(float alpha, float beta, float gamma);
        static Matrix3f matrix(const Vector3f &angles);
        static void angles(Matrix3f R, float &alpha, float &beta, float &gamma);
        static Vector3f angles(Matrix3f R);   // returns (alpha, beta, gamma)

        static Matrix3d matrixD(double alpha, double beta, double gamma);
        static Matrix3d matrixD(const Vector3d &angles);

        template <typename T> static Matrix<T, 3, 3> rotationX(T theta)
        {
            const double c = cos(theta);
            const double s = sin(theta);
            Matrix<T, 3, 3> rot;
            rot <<  1 , 0 , 0,
                    0 , c ,-s,
                    0 , s , c;
            return rot;
        }

        template <typename T> static Matrix<T, 3, 3> rotationY(T theta)
        {
            const double c = cos(theta);
            const double s = sin(theta);
            Matrix<T, 3, 3> rot;
            rot <<  c , 0 , s,
                    0 , 1 , 0,
                   -s , 0 , c;
            return rot;
        }

        template <typename T> static Matrix<T, 3, 3> rotationZ(T theta)
        {
            const double c = cos(theta);
            const double s = sin(theta);
            Matrix<T, 3, 3> rot;
            rot <<  c ,-s , 0,
                    s , c , 0,
                    0 , 0 , 1;
            return rot;
        }
    };
            
#endif

