/**
 *  stringzip.h
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2016  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef STRINGZIP_H
#define STRINGZIP_H

#include <iostream>
#include <cstring>
#include <string.h>
#include <stdexcept>
#include <cstdlib>

#include "zlib.h"

#include "bytearray.h"

class StringZip
{
private:
    char* str;

    size_t size;

public:
    /**
     * @brief StringZip Initializes StringZip with string to zip or unzip
     * @param str_to_zip string to be zipped or unzipped.
     */
    StringZip(ByteArray &str_to_zip);

    ~StringZip();
    /**
     * @brief zip zips the input string.
     * Code inspired from https://gist.github.com/arq5x/5315739.
     * @return the zipped string.
     */
    ByteArray zip();

    /**
     * @brief unzip unzips the input string.
     * Code inspired from https://gist.github.com/arq5x/5315739.
     * @return the unzipped string.
     */
    std::string unzip();

};

#endif // STRINGZIP_H
