/**
 * Persistable.h
 *
 *  Created on: Nov 19, 2014
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */


#ifndef PERSISTABLE_H_
#define PERSISTABLE_H_

#include <QDomDocument>
#include <QXmlStreamReader>

class Persistable{

public:
	/**
	 * Converts the object into XMLElement of QtXML library
	 */
    virtual QDomElement toXMLElement(QDomDocument &doc) = 0;

	/**
	 * Initializes the object from XMLElement of QtXML library
	 */
	virtual void initFromXMLElement(QDomElement &e) = 0;

	virtual void initWithXmlStreamReader(QXmlStreamReader &xml) = 0;

    virtual void saveToXmlStream(QXmlStreamWriter &xml) = 0;

};


#endif /* PERSISTABLE_H_ */
