import global_var
from itertools import product
import re


# funkcia na nahradenie hodnot a vyhodnotenie vyrazu
# vstupom je vyraz, hodnoty a premenna indikujuci poziciu daneho vyrazu, nastavi hodnotu v globalnom poli flagov pre vyrazy
def myEval(values, expression, myiter):

    # kontrola, ci operator bol !=
    not_eq = re.search(r'(.*) != (.*)', expression)

    # iteracia nad kartezskym sucinom hodnot
    for items in product(*values):

        # docasny zoznam pre ulozenie hodnot prvku kartezskeho sucinu
        tmp = []

        # prechod cez hodnoty daneho prvku kart. sucinu
        for i in items:
            tmp.append(i)

        # aplikovanie format, nahradenie {} hodnotami
        toeval = expression.format(*tmp)

        # kontrola ci sa vo vyraze vyskytoval retazec
        r = re.search(r'(.*) [!=]{2} \".*\"', toeval)

        # rovnaka kontrola len na druhej strane
        if not r:
            r = re.search(r'\".*\" [!=]{2} (.*)', toeval)

        # ak sa vyskytoval retazec, tak pridaju sa uvodzovky aj na druhu stranu
        if r:
            toeval = re.sub(r'(?<!\")' + re.escape(r.group(1)) + r'(?!\")', '"' + r.group(1) + '"', toeval, count=1)  # pridanie uvodzoviek

        # ak bol operator !=
        if not_eq:
            if eval(toeval):
                global_var.flags[myiter] = True
            else:
                global_var.flags[myiter] = False
                return

        # ak nebol !=
        else:
            if eval(toeval):
                global_var.flags[myiter] = True
                return


# ine vyhodnotenie, pre pomocne funkcie - kontroluje ci podmienka je pravda, ak ano tak vtedy sa ulozi hodnota fieldu
# vstupom je vyraz a hodnoty, vrati hodnoty kde platila podmienka v parametre
def evalFunction(values, expression):

    # zoznam pre vysledky
    truevalues = []

    # prechadzanie jednotlivych konbinacii hodnot
    for i in range(len(values[0])):  # podpora pre 1 field
        toeval = expression
        for j in range(len(global_var.fields)):
            toeval = re.sub('\\b' + global_var.fields[j] + '\\b', values[j][i], toeval)

        # ak na jednej strane string
        r = re.search(r'([a-zA-Z:0-9.]+) [!=]{2} \".*\"', toeval)

        # ak boli uvodzovky tak aj druha strana sa da do uvodzoviek
        if r:
            toeval = re.sub(re.escape(r.group(1)), '"' + r.group(1) + '"', toeval, count=1)  # pridanie uvodzoviek
            if eval(toeval):
                truevalues.append(values[0][i])

        else:
            if eval(toeval):
                truevalues.append(values[0][i])

    global_var.fields = []  # vycistime zoznam fieldov po kontrole
    return truevalues


# funkcia na vyhodnotenie platnosti slabiny na zaklade vysledku vyrazov a operatora
# vstupom je operator, na zaklade ktoreho vyhodnoti pole flagov pre vyrazy, vrati vysledok vyhodnotenia
def result(operator):
    if operator == 'AND':
        flag = True
        for i in range(len(global_var.flags)):
            flag = flag and global_var.flags[i]
            global_var.flags[i] = False
        return flag
    elif operator == 'OR':
        flag = False
        for i in range(len(global_var.flags)):
            flag = flag or global_var.flags[i]
            global_var.flags[i] = False
        return flag
    else:  # ak iny operator, tak sa pouzije and
        print("Nepodporvany operator, pouzije sa AND")
        flag = True
        for i in range(len(global_var.flags)):
            flag = flag and global_var.flags[i]
            global_var.flags[i] = False
        return flag
