import json
from os import listdir
from os.path import isfile, join
from sys import stderr
from subprocess import check_output
from operator import itemgetter

import src.globs as globs

def pcaplist(args):
    try:
        files = [f for f in listdir(args.idir) if isfile(join(args.idir, f))]
    except FileNotFoundError as err:
        raise RuntimeError("Not a directory")
        return
    pcaps = []
    for f in files:
        if not args.json and f.endswith(".pcap"):
            pcaps.append(args.idir + f)
        if args.json and f.endswith(".json"):
            pcaps.append(args.idir + f)
    return pcaps

#Hanlde multiple duplicate keys in json --> dict
def dict_handle_duplicates(pairs):
    d = {}
    i = 2
    for k, v in pairs:
        if k in d:
            k = k + str(i)
            i += 1
        d[k] = v
    return d

def merge_request_response(requests, responses):
    while (len(requests) != len(responses)):
        merged = sorted(requests + responses, key = itemgetter(1))
        if merged[0] in requests:
            last = "req"
        else:
            last = "res"
        for m in merged[1:]:
            if m in requests and last == "req":
                del requests[requests.index(m) - 1]
                break
            if m in responses and last == "res":
                del responses[responses.index(m) - 1]
                break
            if last == "req":
                last = "res"
            else:
                last = "req"
    commands = []
    for req, res in zip(requests, responses):
        tmp = (req[0], res[0])
        commands.append(str(tmp))

    return commands
    
def find_command(packet, args, requests, responses, packet_num, cmd_found):
    for cf in args.clientfield:
        if cf in packet:
            if len(packet[cf]) <= args.maxlen and not cmd_found:
                requests.append((packet[cf].upper(), packet_num))
            return True
    for sf in args.serverfield:
        if sf in packet:
            if len(packet[sf]) <= args.maxlen and not cmd_found:
                responses.append((packet[sf].upper(), packet_num))
            if not requests:
                requests.append(("NONE", -1))
            return True
    for k, v in packet.items():
        if isinstance(v, dict):
            cmd_found = find_command(   v, 
                                        args, 
                                        requests, 
                                        responses, 
                                        packet_num, 
                                        cmd_found)

def parse_pcap(pcap, args):
    null = None
    try:
        null = open("/dev/null", "w+")
    except:
        pass
    if not args.json:
        command = ["tshark", "-T", "json", "-r", pcap]
        content = check_output(command, stderr = null).decode()
    else:
        with open(pcap) as f:
            content = f.read()
    jsn = json.loads(content, object_pairs_hook = dict_handle_duplicates)
    requests = []
    responses = []
    for packet_num, packet in enumerate(jsn):
        cmd_found = False
        find_command(packet, args, requests, responses, packet_num, cmd_found)
    return  merge_request_response(requests, responses)

def get_commands(args):
    with open(globs.fdir + "/fields.json") as f:
        content = f.read()
    jsn = json.loads(content)
    for c in args.clientfield:
        if c not in jsn:
            raise RuntimeError("\"" + c + "\" is unknown field descriptor")
            return
    for s in args.serverfield:
        if s not in jsn:
            raise RuntimeError("\"" + s + "\" is unknown field descriptor")
            return
    commands = []
    if args.correct:
        try:
            pcaps = pcaplist(args)
        except RuntimeError as err:
            raise RuntimeError(err)
            return
        for p in pcaps:
            c = parse_pcap(p, args)
            commands.append(c)
        if len(commands) == 0:
            raise RuntimeError("No pcap for training found")
    if args.incorrect or args.check:
        if not isfile(args.ifile):
            raise RuntimeError("Is not file")
            return
        commands = parse_pcap(args.ifile, args)
    ret = [x for x in commands if x != []] 
    return ret
