# Projekt:  Bakalářská práce
# Název:    Extrakce tunelovaných dat do samostatných toků
# Autor:    Roman Nahálka, xnahal01@stud.fit.vutbr.cz
# Datum:    17.02.2018
# Soubor:   arguments.py
# Popis:    Třída, která reprezentuje argumenty zadané z příkazové řádky.
#           Třída má na starost zpracování a kontrolu argumentů, zadaných z příkazové řádky.

import argparse
import sys
import error
import os.path


class Arguments:
    def __init__(self):
        self.__args = ""

    def parseArguments(self):
        # Budeme pouzivat argumenty jen pro napovedu a vstupni soubor.
        parser = argparse.ArgumentParser(add_help=False)
        parser.add_argument('-h', '--help', action='store_true', help='Vypíše nápovědu', dest='help')
        parser.add_argument('-f', '--file', action='store', help='Vstupní soubor', dest='file')
        parser.add_argument('-d', '--dir', action='store', help='Vystupni slozka', dest='dir')
        parser.add_argument('-a', '--all', action='store_true', help='Pouze bez všech zapouzdření', dest='all')

        if len(sys.argv) < 3:
            self.__printHelp(parser)

        try:
            self.__args = parser.parse_args()

        except:
            error.printErr(error.Errors.BAD_ARGUMENT, -1)

        params = ['-h', '--help', '-f', '--file', 'd', '--dir', '-a', '--all']

        for p in params:
            if sys.argv.count(p) > 1:
                error.printErr(error.Errors.MULTIPLE_ARGUMENTS, -1)

        if sys.argv.count('-f') == 1 and sys.argv.count('--file') == 1:
            error.printErr(error.Errors.MULTIPLE_ARGUMENTS, -1)

        if sys.argv.count('-h') == 1 and sys.argv.count('--help') == 1:
            error.printErr(error.Errors.MULTIPLE_ARGUMENTS, -1)

        if sys.argv.count('-d') == 1 and sys.argv.count('--dir') == 1:
            error.printErr(error.Errors.MULTIPLE_ARGUMENTS, -1)

        if sys.argv.count('-a') == 1 and sys.argv.count('--all') == 1:
            error.printErr(error.Errors.MULTIPLE_ARGUMENTS, -1)

        if self.__args.help:
            self.__printHelp(parser)

        if not os.path.isfile(self.__args.file):
            error.printErr(error.Errors.NO_FILE, -2)

    @staticmethod
    def __printHelp(parser):
        # Vypsani napovedy
        parser.print_help()
        sys.exit(0)

    @property
    def getArgs(self):
        return self.__args
