#!/bin/bash
#nazev           :install_centos.sh
#popis           :Skript nainstaluje interpret Pythonu, knihovnu PyYAML a nastroj wireshark + tshark nutny pro beh nastroje na operacnim systemu CentOS.
#autor           :Jindrich Dudek (xdudek04)
#datum           :9.5.2018
#pouziti         :./install_centos.sh (pripadne chmod +x install_centos.sh, pro nastaveni priznaku spustitelnosti)
#testovano       :CentOS 7

# Nainstalovani potrebnych knihoven pro kompilaci wiresharku:
sudo yum --enablerepo=extras -y install epel-release  # Pro moznost nainstalovat python-pip
sudo yum -y install python python-pip gcc gcc-c++ bison flex libpcap-devel qt-devel gtk3-devel rpm-build libtool c-ares-devel qt5-qtbase-devel qt5-qtmultimedia-devel qt5-linguist desktop-file-utils libgcrypt-devel

# Urceni verze wiresharku, mozne zmenit na zaklade aktualnich verzi https://www.wireshark.org/download/src/
file_name=wireshark-2.5.1
suffix=tar.xz

# Stazeni wiresharku, nutne timto zpusobem, v repozitari jsou prilis stare verze.
wget https://www.wireshark.org/download/src/$file_name.$suffix  # Stazeni wiresharku
tar -xf $file_name.$suffix -C /tmp  # Rozbaleni wiresharku
cd /tmp/$file_name

# Instalace wiresharku
./autogen.sh
./configure -enable-setcap-install
make
sudo make install
sudo ldconfig

sudo pip install pyyaml  # Instalace PyYAML
